#include "UG3_LIB.h"

void ug3_reorderb
 (INT_ nbface,
  INT_ nelem,
  INT_ nelemc5,
  INT_ nelemc6,
  INT_ nelemc8,
  INT_ nnode,
  INT_ *nnodeb,
  INT_ nquad,
  INT_3D * inibf,
  INT_4D * iniel,
  INT_5D * inielc5,
  INT_6D * inielc6,
  INT_8D * inielc8,
  INT_4D * iniq,
  INT_1D * jnin,
  INT_1D * mflag,
  DOUBLE_1D * del,
  DOUBLE_1D * df,
  DOUBLE_1D * ds,
  DOUBLE_6D * met,
  DOUBLE_4D * trv,
  DOUBLE_4D * trw,
  DOUBLE_3D * x)

{

/*
 * Re-orders nodes so that all boundary nodes are first in the ordering.
 *
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_reorderb.c,v 1.33 2023/07/12 19:16:30 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ibface, inode, inode0, inode1, inode2, inode3, inode4, iquad,
       mchk, mflagi;

  mchk = (*nnodeb == -1) ? 1: 0;

  if (*nnodeb != -2)
    ug_set_int (1, nnode, 1, mflag);

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    inode1 = inibf[ibface][0];
    inode2 = inibf[ibface][1];
    inode3 = inibf[ibface][2];

    mflag[inode1] = 0;
    mflag[inode2] = 0;
    mflag[inode3] = 0;
  }

  for (iquad = 1; iquad <= nquad; ++iquad)
  {
    inode1 = iniq[iquad][0];
    inode2 = iniq[iquad][1];
    inode3 = iniq[iquad][2];
    inode4 = iniq[iquad][3];

    mflag[inode1] = 0;
    mflag[inode2] = 0;
    mflag[inode3] = 0;
    mflag[inode4] = 0;
  }

  *nnodeb = nnode+1;

  do
  {
    --(*nnodeb);
  }
  while (*nnodeb > 1 && mflag[*nnodeb] == 1);

  inode0 = 0;

  do
  {
    ++inode0;

    mflagi = mflag[inode0];
  }
  while (inode0 < *nnodeb && mflagi == 0);

  if (mflagi == 1 && mchk)
    *nnodeb = -1;

  else if (mflagi == 1)
  {
    ug3_reorder0n (&inode0, nbface, nelem, nelemc5, nelemc6, nelemc8,
                   nnode, *nnodeb, nquad,
                   inibf, iniel, inielc5, inielc6, inielc8, iniq,
                   jnin, mflag,
                   del, df, ds, met, trv, trw, x);

    *nnodeb = inode0-1;
  }

  else if (mchk == 0)
  {
    for (inode = 1; inode <= nnode; ++inode)
    {
      jnin[inode] = inode;
    }
  }

  return;

}

INT_ ug3_reorderb2
 (INT_ nbedge,
  INT_ nbface,
  INT_ nelem,
  INT_ nelemc5,
  INT_ nelemc6,
  INT_ nelemc8,
  INT_ nnode,
  INT_ *nnodeb,
  INT_ nquad,
  INT_2D * inibe,
  INT_3D * inibf,
  INT_4D * iniel,
  INT_5D * inielc5,
  INT_6D * inielc6,
  INT_8D * inielc8,
  INT_4D * iniq,
  DOUBLE_1D * del,
  DOUBLE_1D * df,
  DOUBLE_1D * ds,
  DOUBLE_6D * met,
  DOUBLE_4D * trv,
  DOUBLE_4D * trw,
  DOUBLE_3D * x)

{

  INT_1D *jnin = NULL;
  INT_1D *mflag = NULL;

  INT_ ibedge = 0;
  INT_ ierr = 0;

  jnin = (INT_1D *) ug_malloc (&ierr, (nnode+1) * sizeof (INT_1D));
  mflag = (INT_1D *) ug_malloc (&ierr, (nnode+1) * sizeof (INT_1D));

  if (ierr == 0)
  {
    ug3_reorderb (nbface, nelem, nelemc5, nelemc6, nelemc8, nnode, nnodeb,
                  nquad,
                  inibf, iniel, inielc5, inielc6, inielc8, iniq,
                  jnin, mflag,
                  del, df, ds, met, trv, trw, x);

    if (inibe)
    {
      for (ibedge = 1; ibedge <= nbedge; ibedge++)
      {
        inibe[ibedge][0] = jnin[inibe[ibedge][0]];
        inibe[ibedge][1] = jnin[inibe[ibedge][1]];
      }
    }
  }

  ug_free (jnin);
  ug_free (mflag);

  if (ierr)
  {
    ug_error_message ("*** ERROR 100318 : unable to allocate required memory ***");
    return (100318);
  }

  return (0);

}
