#include "UG3_LIB.h"

INT_ ug3_read_surf_grid_file2 (
  char File_Name[],
  INT_ mibcibf,
  INT_ midibf,
  INT_ mirfibf,
  INT_ mmsg,
  INT_ no_quad,
  INT_ *nnode,
  INT_ *nquad,
  INT_ *nbface,
  INT_1D ** ibcibf,
  INT_1D ** idibf,
  INT_4D ** iniq,
  INT_1D ** irfibf,
  INT_3D ** inibf,
  DOUBLE_3D ** x)

{

/*
 * Read grid data from a SURF surface grid file. This version allocates space with
 * options.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_read_surf_grid_file2.c,v 1.7 2022/11/21 00:25:14 marcum Exp $
 * Copyright 1994-2021, David L. Marcum 
 */

  CHAR_UG_MAX drive, dname, ext, fname, suffix, Text;
  CHAR_51 Name_Text;

  INT_ ierr = 0;
  INT_ nsurf = 0;

  *nnode = 0;
  *nquad = 0;
  *nbface = 0;

  strcpy (Text, File_Name);
  strcat (Text, ".surf");

  ug_uncompress_file2 (Text, suffix);

  ierr = ug3_read_surf_grid_file (File_Name, 1, nnode, nquad, nbface,
                                  *ibcibf, *idibf, *iniq, *irfibf, *inibf, *x);

  if (ierr == 0 && mmsg) {
    ug_splitpath (File_Name, drive, dname, fname, ext);

    strcat (fname, ext);
    strcpy (Name_Text, "");
    strncat (Name_Text, fname, 50);

    snprintf (Text, sizeof(Text), "UG3      : Surf File Name    = %s", Name_Text);
    ug_message (Text);
  }

  if (ierr == 0) {
    nsurf = (*nbface) + (*nquad);
    if (mibcibf) *ibcibf = (INT_1D *) ug_malloc (&ierr, (nsurf+1) * sizeof (INT_1D));
    if (midibf) *idibf = (INT_1D *) ug_malloc (&ierr, (nsurf+1) * sizeof (INT_1D));
    if (mirfibf) *irfibf = (INT_1D *) ug_malloc (&ierr, (nsurf+1) * sizeof (INT_1D));
    *iniq = (INT_4D *) ug_malloc (&ierr, ((*nquad)+1) * sizeof (INT_4D));
    *inibf = (INT_3D *) ug_malloc (&ierr, ((*nbface)+1) * sizeof (INT_3D));
    *x = (DOUBLE_3D *) ug_malloc (&ierr, ((*nnode)+1) * sizeof (DOUBLE_3D));

    if (ierr) {
      ug_error_message ("*** ERROR 100354 : unable to allocate required memory ***");
      ierr = 100354;
    }
  }

  if (ierr == 0)
    ierr = ug3_read_surf_grid_file (File_Name, 2, nnode, nquad, nbface,
                                    *ibcibf, *idibf, *iniq, *irfibf, *inibf, *x);

  if (ierr == 0 && no_quad)
  {
    ierr = ug3_qtria (0, 0, nbface, nquad,
                      ibcibf, idibf, NULL, inibf, *iniq, NULL, irfibf, *x);

    *nquad = 0;

    ug_free (*iniq);
    *iniq = NULL;
  }

  if (ierr == 0 && mmsg) {
    if (*nquad) {
      snprintf (Text, sizeof(Text), "UG3      : Quad Surface Faces=%10i", (int) *nquad);
      ug_message (Text);
    }
    snprintf (Text, sizeof(Text), "UG3      : Tria Surface Faces=%10i", (int) *nbface);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG3      : Nodes             =%10i", (int) *nnode);
    ug_message (Text);
    ug_message (" ");
  }

  ug_compress_file (1, suffix, File_Name);

  return ierr;
}
