#include "UG3_LIB.h"

INT_ ug3_read_surf_grid_file
 (char File_Name[],
  INT_ Read_Task_Flag,
  INT_ *Number_of_Nodes,
  INT_ *Number_of_Surf_Quads,
  INT_ *Number_of_Surf_Trias,
  INT_1D * Surf_Grid_BC_Flag,
  INT_1D * Surf_ID_Flag,
  INT_4D * Surf_Quad_Connectivity,
  INT_1D * Surf_Reconnection_Flag,
  INT_3D * Surf_Tria_Connectivity,
  DOUBLE_3D * Coordinates)

{

/*
 * Read grid data from a SURF surface grid file.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_read_surf_grid_file.c,v 1.21 2022/11/21 00:25:14 marcum Exp $
 * Copyright 1994-2021, David L. Marcum 
 */

  CHAR_UG_MAX drive, dname, ext, fname, Text;
  CHAR_51 Name_Text;

  FILE *Grid_File;

  DOUBLE_1D *Initial_Normal_Spacing = NULL;
  DOUBLE_1D *BL_Thickness = NULL;

  INT_ ierr = 0;

  if (Read_Task_Flag == 1)
    strcat (File_Name, ".surf");

  if (ug_file_status_monitor_flag())
  {
    ug_splitpath (File_Name, drive, dname, fname, ext);

    strcat (fname, ext);
    strcpy (Name_Text, "");
    strncat (Name_Text, fname, 50);

    snprintf (Text, sizeof(Text), "ug3_read_surf_grid_file  : reading SURF file with File_Name=%s Read_Task_Flag=%i", Name_Text, (int) Read_Task_Flag);
    ug_message (Text);
  }

  Grid_File = ug_fopen (File_Name, "r");

  if (Grid_File == NULL)
  {
    ug_error_message ("*** ERROR 337 : error reading SURF surface grid file ***");
    return (337);
  }

  ierr = ug3_read_surf (Grid_File, Read_Task_Flag, Number_of_Nodes,
                        Number_of_Surf_Quads, Number_of_Surf_Trias,
                        Surf_Grid_BC_Flag, Surf_ID_Flag, Surf_Quad_Connectivity,
                        Surf_Reconnection_Flag, Surf_Tria_Connectivity,
                        Coordinates, Initial_Normal_Spacing, BL_Thickness);

  ug_fclose (Grid_File);

  if (ierr)
    return (337);

  return (0);

}
