#include "UG3_LIB.h"

INT_ ug3_read_split_data_file (char File_Name[],
                               INT_ mmsg,
                               INT_ *nsplit,
                               INT_1D ** ielc8isplit,
                               INT_1D ** ielc8fisplit,
                               INT_9D ** inisplit)
{

/*
 * Read hex-element split-face data from a SPLIT data file.
 *
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_read_split_data_file.c,v 1.6 2022/11/21 00:25:14 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_UG_MAX File_Type, drive, dname, fname, ext, Text;
  CHAR_51 Name_Text;

  FILE *Data_File;

  INT_ i, File_Mode, File_Format, isplit;
  INT_ ierr = 0;
  INT_ Read_Flag = 1;

  ierr = ug_file_format_check (File_Name);

  if (ierr)
    return (ierr);

  ug_file_info (File_Name, File_Type, &File_Format, &File_Mode);

  if (strcmp (File_Type, ".split"))
    return (0);

  ug_splitpath (File_Name, drive, dname, fname, ext);

  strcat (fname, ext);
  strcpy (Name_Text, "");
  strncat (Name_Text, fname, 50);

  if (ug_file_status_monitor_flag())
  {
    snprintf (Text, sizeof(Text), "ug3_read_split_data_file : reading file with File_Name=%s File_Type=%s File_Format=%i", Name_Text, File_Type, (int) File_Format);
    ug_message (Text);
  }

  if (mmsg >= 1)
  {
    ug_message (" ");
    ug_message ("UG3      : INPUT SPLIT DATA");
    ug_message (" ");

    snprintf (Text, sizeof(Text), "UG3      : Split File Name   = %s", Name_Text);
    ug_message (Text);
  }

  Data_File = ug_fopen (File_Name, "r");

  if (Data_File == NULL)
  {
    ug_error_message ("*** ERROR 366 : error opening SPLIT data file ***");
    return (366);
  }

  if (File_Format == UG_FIO_FORMATTED)
    Read_Flag = fscanf (Data_File, "%i", (int *) nsplit);
  else
    Read_Flag = ug_fread (nsplit, sizeof (INT_), 1, Data_File);

  if (mmsg >= 1)
  {
    snprintf (Text, sizeof(Text), "UG3      : Hex-Split-Faces   =%10i", (int) *nsplit);
    ug_message (Text);
  }

  if (Read_Flag > 0)
  {
    *ielc8isplit = (INT_1D *) ug_malloc (&ierr, ((*nsplit)+1) * sizeof (INT_1D));
    *ielc8fisplit = (INT_1D *) ug_malloc (&ierr, ((*nsplit)+1) * sizeof (INT_1D));
    *inisplit = (INT_9D *) ug_malloc (&ierr, ((*nsplit)+1) * sizeof (INT_9D));

    if (ierr)
    {
      ug_error_message ("*** ERROR 100344 : unable to allocate required memory ***");
      return (100344);
    }
  }

  isplit = 1;

  while (isplit <= *nsplit && Read_Flag > 0)
  {
    if (File_Format == UG_FIO_FORMATTED)
      Read_Flag = fscanf (Data_File, "%i %i %i %i %i %i %i %i %i %i %i",
                                     (int *) &((*ielc8isplit)[isplit]),
                                     (int *) &((*ielc8fisplit)[isplit]),
                                     (int *) &((*inisplit)[isplit][0]),
                                     (int *) &((*inisplit)[isplit][1]),
                                     (int *) &((*inisplit)[isplit][2]),
                                     (int *) &((*inisplit)[isplit][3]),
                                     (int *) &((*inisplit)[isplit][4]),
                                     (int *) &((*inisplit)[isplit][5]),
                                     (int *) &((*inisplit)[isplit][6]),
                                     (int *) &((*inisplit)[isplit][7]),
                                     (int *) &((*inisplit)[isplit][8]));
    else
    {
      Read_Flag = ug_fread (&((*ielc8isplit)[isplit]), sizeof (INT_), 1, Data_File);
      Read_Flag = ug_fread (&((*ielc8fisplit)[isplit]), sizeof (INT_), 1, Data_File);
      for (i = 0; i < 9; ++i)
      {
        Read_Flag = ug_fread (&((*inisplit)[isplit][i]), sizeof (INT_), 1, Data_File);
      }
    }

    ++isplit;
  }

  ug_fclose (Data_File);

  if (Read_Flag <= 0)
  {
    ug_error_message ("*** ERROR 367 : error reading SPLIT data file ***");
    return (367);
  }

  return (0);
}
