#include "UG3_LIB.h"

INT_ ug3_read_grid_file2 (char File_Name[],
                          INT_ Message_Flag,
                          INT_ M_Bnd_Data_Flag,
                          INT_ M_Vol_ID_Flag,
                          INT_ No_Alloc,
                          INT_ *Number_of_Bnd_Nodes,
                          INT_ *Number_of_Nodes,
                          INT_ *Number_of_Bnd_Edges,
                          INT_ *Number_of_Surf_Quads,
                          INT_ *Number_of_Surf_Trias,
                          INT_ *Number_of_Vol_Hexs,
                          INT_ *Number_of_Vol_Pents_5,
                          INT_ *Number_of_Vol_Pents_6,
                          INT_ *Number_of_Vol_Tets,
                          INT_1D ** Bnd_Edge_ID_Flag,
                          INT_2D ** Bnd_Edge_Connectivity,
                          INT_1D ** Surf_Grid_BC_Flag,
                          INT_1D ** Surf_ID_Flag,
                          INT_1D ** Surf_Reconnection_Flag,
                          INT_4D ** Surf_Quad_Connectivity,
                          INT_3D ** Surf_Tria_Connectivity,
                          INT_8D ** Vol_Hex_Connectivity,
                          INT_1D ** Vol_ID_Flag,
                          INT_5D ** Vol_Pent_5_Connectivity,
                          INT_6D ** Vol_Pent_6_Connectivity,
                          INT_4D ** Vol_Tet_Connectivity,
                          DOUBLE_3D ** Coordinates,
                          DOUBLE_1D ** Initial_Normal_Spacing,
                          DOUBLE_1D ** BL_Thickness)
{

/*
 * Read grid data from a volume or surface grid file.
 *
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_read_grid_file2.c,v 1.17 2024/11/02 06:00:34 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  FILE *Grid_File = NULL;

  CHAR_UG_MAX drive, dname, fname, ext, File_Type, Text;
  CHAR_51 Name_Text;

  INT_ File_Mode, File_Format, i1, i2,
       Number_of_Surf_Faces, Number_of_Vol_Elements, Read_Task_Flag;
  INT_ ierr = 0;

  *Number_of_Bnd_Edges = 0;

  ierr = ug_file_format_check (File_Name);

  if (ierr)
    return (ierr);

  ug_file_info (File_Name, File_Type, &File_Format, &File_Mode);

  ug_splitpath (File_Name, drive, dname, fname, ext);

  strcat (fname, ext);
  strcpy (Name_Text, "");
  strncat (Name_Text, fname, 50);

  if (ug_file_status_monitor_flag())
  {
    snprintf (Text, sizeof(Text), "ug3_read_grid_file: reading file with File_Name=%s File_Type=%s File_Format=%i", Name_Text, File_Type, (int) File_Format);
    ug_message (Text);
  }

  if (File_Mode == UG_FIO_TMP_FILE_MODE)
  {
    strcpy (fname, File_Name);
    strcat (fname, "+");
  }

  i1 = (No_Alloc == 2) ? 2: 1;
  i2 = (No_Alloc == 1) ? 1: 2;

  for (Read_Task_Flag = i1; Read_Task_Flag <= i2; ++Read_Task_Flag)
  {
    if (strcmp (File_Type, ".ugrid") == 0)
    {
      if (File_Mode == UG_FIO_TMP_FILE_MODE)
      {
        if (ug_file_status_monitor_flag())
          ug_message ("ug3_read_grid_file: opening file in TMP file mode");

        Grid_File = ug_fopen (fname, "r_tmp");

        ug_rewind (Grid_File);
      }
      else
      {
        if (ug_file_status_monitor_flag())
          ug_message ("ug3_read_grid_file: opening file in STANDARD file mode");

        Grid_File = ug_fopen (File_Name, "r");
      }

      if (Grid_File == NULL)
      {
        ug_error_message ("*** ERROR 338 : error opening grid file ***");
        return (338);
      }

      if (No_Alloc && Read_Task_Flag == 2 &&
          Message_Flag >= 1 && File_Mode == UG_FIO_STANDARD_FILE_MODE)
      {
        ug_message (" ");
        ug_message ("UG3      : INPUT GRID");
        ug_message (" ");
        snprintf (Text, sizeof(Text), "UG3      : Grid File Name    = %s", Name_Text);
        ug_message (Text);
        if (*Number_of_Bnd_Edges)
        {
          snprintf (Text, sizeof(Text), "UG3      : Boundary Edges    =%10i", (int) *Number_of_Bnd_Edges);
          ug_message (Text);
        }
        snprintf (Text, sizeof(Text), "UG3      : Quad Surface Faces=%10i", (int) *Number_of_Surf_Quads);
        ug_message (Text);
        snprintf (Text, sizeof(Text), "UG3      : Tria Surface Faces=%10i", (int) *Number_of_Surf_Trias);
        ug_message (Text);
        if (*Number_of_Bnd_Nodes)
        {
          snprintf (Text, sizeof(Text), "UG3      : Nodes             =%10i", (int) *Number_of_Bnd_Nodes);
          ug_message (Text);
          ug_message (" ");
        }
        else
        {
          snprintf (Text, sizeof(Text), "UG3      : Nodes             =%10i", (int) *Number_of_Nodes);
          ug_message (Text);
          snprintf (Text, sizeof(Text), "UG3      : Hex Elements      =%10i", (int) *Number_of_Vol_Hexs);
          ug_message (Text);
          snprintf (Text, sizeof(Text), "UG3      : Pent_5 Elements   =%10i", (int) *Number_of_Vol_Pents_5);
          ug_message (Text);
          snprintf (Text, sizeof(Text), "UG3      : Pent_6 Elements   =%10i", (int) *Number_of_Vol_Pents_6);
          ug_message (Text);
          snprintf (Text, sizeof(Text), "UG3      : Tet Elements      =%10i", (int) *Number_of_Vol_Tets);
          ug_message (Text);
          ug_message (" ");
        }
      }

      ierr = ug3_read_ugrid (Grid_File, File_Format, Read_Task_Flag,
                             Number_of_Bnd_Nodes,
                             Number_of_Nodes,
                             Number_of_Surf_Quads, Number_of_Surf_Trias,
                             Number_of_Vol_Hexs,
                             Number_of_Vol_Pents_5,
                             Number_of_Vol_Pents_6,
                             Number_of_Vol_Tets,
                             *Surf_ID_Flag,
                             *Surf_Quad_Connectivity, *Surf_Tria_Connectivity,
                             *Vol_Hex_Connectivity,
                             *Vol_ID_Flag,
                             *Vol_Pent_5_Connectivity,
                             *Vol_Pent_6_Connectivity,
                             *Vol_Tet_Connectivity,
                             *Coordinates);

      if (ierr == 0 && M_Bnd_Data_Flag)
        ug3_read_gdata (Grid_File, File_Format,
                        *Number_of_Nodes,
                        *Number_of_Surf_Quads, *Number_of_Surf_Trias,
                        *Surf_Grid_BC_Flag, *Surf_Reconnection_Flag,
                        *Initial_Normal_Spacing, *BL_Thickness);

      else if (ierr == 0)
      {
        if (*Surf_Grid_BC_Flag)
          ug_set_int (1, (*Number_of_Surf_Quads)+(*Number_of_Surf_Trias),
                      -STD_UG3_GBC, *Surf_Grid_BC_Flag);
        if (*Surf_Reconnection_Flag)
          ug_set_int (1, (*Number_of_Surf_Quads)+(*Number_of_Surf_Trias),
                      0, *Surf_Reconnection_Flag);
      }

      if (File_Mode == UG_FIO_TMP_FILE_MODE)
        ug_rewind (Grid_File);
      else
        ug_fclose (Grid_File);

      Grid_File = NULL;
    }

    else if (strcmp (File_Type, ".mesh") == 0 || strcmp (File_Type, ".meshb") == 0)
      ierr = ug3_read_mesh (File_Name, Read_Task_Flag,
                            Number_of_Bnd_Nodes,
                            Number_of_Nodes,
                            Number_of_Bnd_Edges,
                            Number_of_Surf_Quads, Number_of_Surf_Trias,
                            Number_of_Vol_Hexs,
                            Number_of_Vol_Pents_5,
                            Number_of_Vol_Pents_6,
                            Number_of_Vol_Tets,
                            *Bnd_Edge_ID_Flag,
                            *Bnd_Edge_Connectivity,
                            *Surf_ID_Flag,
                            *Surf_Quad_Connectivity, *Surf_Tria_Connectivity,
                            *Vol_Hex_Connectivity,
                            *Vol_ID_Flag,
                            *Vol_Pent_5_Connectivity,
                            *Vol_Pent_6_Connectivity,
                            *Vol_Tet_Connectivity,
                            *Coordinates);

    if (ierr)
    {
      ug_error_message ("*** ERROR 338 : error reading grid file ***");
      return (338);
    }

    if (*Number_of_Bnd_Nodes)
    {
      *Number_of_Vol_Hexs = 0;
      *Number_of_Vol_Pents_5 = 0;
      *Number_of_Vol_Pents_6 = 0;
      *Number_of_Vol_Tets = 0;
    }

    if (Read_Task_Flag == 1 && No_Alloc == 0)
    {
      if (Message_Flag >= 1 && File_Mode == UG_FIO_STANDARD_FILE_MODE)
      {
        ug_message (" ");
        ug_message ("UG3      : INPUT GRID");
        ug_message (" ");
        snprintf (Text, sizeof(Text), "UG3      : Grid File Name    = %s", Name_Text);
        ug_message (Text);
        if (*Number_of_Bnd_Edges)
        {
          snprintf (Text, sizeof(Text), "UG3      : Boundary Edges    =%10i", (int) *Number_of_Bnd_Edges);
          ug_message (Text);
        }
        snprintf (Text, sizeof(Text), "UG3      : Quad Surface Faces=%10i", (int) *Number_of_Surf_Quads);
        ug_message (Text);
        snprintf (Text, sizeof(Text), "UG3      : Tria Surface Faces=%10i", (int) *Number_of_Surf_Trias);
        ug_message (Text);
        if (*Number_of_Bnd_Nodes)
        {
          snprintf (Text, sizeof(Text), "UG3      : Nodes             =%10i", (int) *Number_of_Bnd_Nodes);
          ug_message (Text);
          ug_message (" ");
        }
        else
        {
          snprintf (Text, sizeof(Text), "UG3      : Nodes             =%10i", (int) *Number_of_Nodes);
          ug_message (Text);
          snprintf (Text, sizeof(Text), "UG3      : Hex Elements      =%10i", (int) *Number_of_Vol_Hexs);
          ug_message (Text);
          snprintf (Text, sizeof(Text), "UG3      : Pent_5 Elements   =%10i", (int) *Number_of_Vol_Pents_5);
          ug_message (Text);
          snprintf (Text, sizeof(Text), "UG3      : Pent_6 Elements   =%10i", (int) *Number_of_Vol_Pents_6);
          ug_message (Text);
          snprintf (Text, sizeof(Text), "UG3      : Tet Elements      =%10i", (int) *Number_of_Vol_Tets);
          ug_message (Text);
          ug_message (" ");
        }
      }

      Number_of_Surf_Faces = *Number_of_Surf_Trias + *Number_of_Surf_Quads;

      Number_of_Vol_Elements = (*Number_of_Vol_Hexs) + (*Number_of_Vol_Pents_5)
                             + (*Number_of_Vol_Pents_6) + (*Number_of_Vol_Tets);

      *Bnd_Edge_ID_Flag = NULL;
      *Bnd_Edge_Connectivity = NULL;
      *Surf_Grid_BC_Flag = NULL;
      *Surf_ID_Flag = NULL;
      *Surf_Reconnection_Flag = NULL;
      *Surf_Quad_Connectivity = NULL;
      *Surf_Tria_Connectivity = NULL;
      *Vol_Hex_Connectivity = NULL;
      *Vol_ID_Flag = NULL;
      *Vol_Pent_5_Connectivity = NULL;
      *Vol_Pent_6_Connectivity = NULL;
      *Vol_Tet_Connectivity = NULL;
      *Coordinates = NULL;
      *Initial_Normal_Spacing = NULL;
      *BL_Thickness = NULL;

      if (*Number_of_Bnd_Edges > 0)
      {
        *Bnd_Edge_ID_Flag = (INT_1D *) ug_malloc (&ierr,
                                   ((*Number_of_Bnd_Edges)+1) * sizeof (INT_1D));
        *Bnd_Edge_Connectivity = (INT_2D *) ug_malloc (&ierr,
                                   ((*Number_of_Bnd_Edges)+1) * sizeof (INT_2D));
      }

      if (Number_of_Surf_Faces > 0)
        *Surf_ID_Flag = (INT_1D *) ug_malloc (&ierr,
                                   (Number_of_Surf_Faces+1) * sizeof (INT_1D));

      if (Number_of_Surf_Faces > 0 && M_Bnd_Data_Flag)
      {
        *Surf_Grid_BC_Flag = (INT_1D *) ug_malloc (&ierr,
                                   (Number_of_Surf_Faces+1) * sizeof (INT_1D));

        *Surf_Reconnection_Flag = (INT_1D *) ug_malloc (&ierr,
                                   (Number_of_Surf_Faces+1) * sizeof (INT_1D));
      }

      if (*Number_of_Surf_Trias > 0)
        *Surf_Tria_Connectivity = (INT_3D *) ug_malloc (&ierr,
                                   (*Number_of_Surf_Trias+1) * sizeof (INT_3D));

      if (*Number_of_Surf_Quads > 0)
        *Surf_Quad_Connectivity = (INT_4D *) ug_malloc (&ierr,
                                   (*Number_of_Surf_Quads+1) * sizeof (INT_4D));

      if (*Number_of_Vol_Hexs > 0)
        *Vol_Hex_Connectivity = (INT_8D *) ug_malloc (&ierr,
                                   (*Number_of_Vol_Hexs+1) * sizeof (INT_8D));

                         
      if (M_Vol_ID_Flag && Number_of_Vol_Elements > 0)
        *Vol_ID_Flag = (INT_1D *) ug_malloc (&ierr,
                                   (Number_of_Vol_Elements+1) * sizeof (INT_1D));

      if (*Number_of_Vol_Pents_5 > 0)
        *Vol_Pent_5_Connectivity = (INT_5D *) ug_malloc (&ierr,
                                   (*Number_of_Vol_Pents_5+1) * sizeof (INT_5D));

      if (*Number_of_Vol_Pents_6 > 0)
        *Vol_Pent_6_Connectivity = (INT_6D *) ug_malloc (&ierr,
                                   (*Number_of_Vol_Pents_6+1) * sizeof (INT_6D));

      if (*Number_of_Vol_Tets > 0)
        *Vol_Tet_Connectivity = (INT_4D *) ug_malloc (&ierr,
                                   (*Number_of_Vol_Tets+1) * sizeof (INT_4D));

      if (*Number_of_Nodes > 0)
        *Coordinates = (DOUBLE_3D *) ug_malloc (&ierr,
                                   (*Number_of_Nodes+1) * sizeof (DOUBLE_3D));

      if (*Number_of_Nodes > 0 && M_Bnd_Data_Flag)
      {
        *Initial_Normal_Spacing = (DOUBLE_1D *) ug_malloc (&ierr,
                                   (*Number_of_Nodes+1) * sizeof (DOUBLE_1D));

        *BL_Thickness = (DOUBLE_1D *) ug_malloc (&ierr,
                                   (*Number_of_Nodes+1) * sizeof (DOUBLE_1D));
      }

      if (ierr)
      {
        ug_error_message ("*** ERROR 100305 : unable to allocate required memory ***");
        return (100305);
      }
    }
  }

  return (0);

}
