#include "UG3_LIB.h"

void ug3_read_gdata (FILE * Grid_File,
                     INT_ File_Format,
                     INT_ Number_of_Nodes,
                     INT_ Number_of_Surf_Quads,
                     INT_ Number_of_Surf_Trias,
                     INT_1D * Surf_Grid_BC_Flag,
                     INT_1D * Surf_Reconnection_Flag,
                     DOUBLE_1D * Initial_Normal_Spacing,
                     DOUBLE_1D * BL_Thickness)

{

/*
 * Read boundary surface grid BC, boundary surface reconection flag, BL initial
 * spacing, and BL thicknes.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_read_gdata.c,v 1.4 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ Index, Number_of_Bytes, Number_of_Read_Items, Number_of_Surf_Faces,
       Read_Flag, Special_Read_Items;

  int TMP_int = 0;

  double dc0, TMP_double;

  float fc0, TMP_float;

  dc0 = 0.0;
  fc0 = 0.0;

  Number_of_Surf_Faces = Number_of_Surf_Trias + Number_of_Surf_Quads;

  if (Surf_Reconnection_Flag)
    ug_set_int (1, Number_of_Surf_Faces, 0, Surf_Reconnection_Flag);

  if (Surf_Grid_BC_Flag)
    ug_set_int (1, Number_of_Surf_Faces, 0, Surf_Grid_BC_Flag);

  if (Initial_Normal_Spacing)
    ug_set_double (1, Number_of_Nodes, dc0, Initial_Normal_Spacing);

  if (BL_Thickness)
    ug_set_double (1, Number_of_Nodes, dc0, BL_Thickness);

  Read_Flag = 1;

  if (File_Format == UG_FIO_FORMATTED)
  {
    if (Read_Flag == 1)
    {
      for (Index = 1; Index <= Number_of_Surf_Faces; ++Index)
      {
        Read_Flag = fscanf (Grid_File, "%i", &TMP_int);

        TMP_int = MAX (TMP_int, 0);
        TMP_int = MIN (TMP_int, 7);

        if (Surf_Reconnection_Flag != NULL)
          Surf_Reconnection_Flag[Index] = (INT_) TMP_int;
      }

      if (Read_Flag != EOF)
        Read_Flag = 1;
      else
        Read_Flag = 0;
    }

    if (Read_Flag == 1)
    {
      for (Index = 1; Index <= Number_of_Surf_Faces; ++Index)
      {
        Read_Flag = fscanf (Grid_File, "%i", &TMP_int);

        if (Surf_Grid_BC_Flag != NULL)
          Surf_Grid_BC_Flag[Index] = (INT_) TMP_int;
      }

      if (Read_Flag != EOF)
        Read_Flag = 1;
      else
        Read_Flag = 0;
    }

    if (Read_Flag == 1)
    {
      for (Index = 1; Index <= Number_of_Nodes; ++Index)
      {
        Read_Flag = fscanf (Grid_File, "%lf", &TMP_double);

        if (Initial_Normal_Spacing != NULL)
          Initial_Normal_Spacing[Index] = TMP_double;
      }

      if (Read_Flag != EOF)
        Read_Flag = 1;
      else
        Read_Flag = 0;
    }

    if (Read_Flag == 1)
    {
      for (Index = 1; Index <= Number_of_Nodes; ++Index)
      {
        Read_Flag = fscanf (Grid_File, "%lf", &TMP_double);

        if (BL_Thickness != NULL)
          BL_Thickness[Index] = TMP_double;
      }

      if (Read_Flag != EOF)
        Read_Flag = 1;
      else
        Read_Flag = 0;
    }
  }
  else
  {
    Special_Read_Items = ((File_Format == UG_FIO_UNFORMATTED_DOUBLE ||
                           File_Format == UG_FIO_UNFORMATTED_SINGLE) ? 1 : 0);

    if (Read_Flag == 1)
    {
      Read_Flag = 0;

      if (File_Format == UG_FIO_UNFORMATTED_DOUBLE ||
          File_Format == UG_FIO_UNFORMATTED_SINGLE)
        Read_Flag = Read_Flag + ug_fread (&Number_of_Bytes,
                                          sizeof (INT_), 1, Grid_File);

      for (Index = 1; Index <= Number_of_Surf_Faces; ++Index)
      {
        Read_Flag = Read_Flag + ug_fread (&TMP_int,
                                          sizeof (INT_1D), 1, Grid_File);

        TMP_int = MAX (TMP_int, 0);
        TMP_int = MIN (TMP_int, 7);

        if (Surf_Reconnection_Flag != NULL)
          Surf_Reconnection_Flag[Index] = (INT_) TMP_int;
      }

      if (File_Format == UG_FIO_UNFORMATTED_DOUBLE ||
          File_Format == UG_FIO_UNFORMATTED_SINGLE)
        Read_Flag = Read_Flag + ug_fread (&Number_of_Bytes,
                                          sizeof (INT_), 1, Grid_File);

      Number_of_Read_Items = Number_of_Surf_Faces
                           + Special_Read_Items + Special_Read_Items;

      if (Read_Flag == Number_of_Read_Items)
        Read_Flag = 1;
      else
        Read_Flag = 0;
    }

    if (Read_Flag == 1)
    {
      Read_Flag = 0;

      if (File_Format == UG_FIO_UNFORMATTED_DOUBLE ||
          File_Format == UG_FIO_UNFORMATTED_SINGLE)
        Read_Flag = Read_Flag + ug_fread (&Number_of_Bytes,
                                          sizeof (INT_), 1, Grid_File);

      for (Index = 1; Index <= Number_of_Surf_Faces; ++Index)
      {
        Read_Flag = Read_Flag + ug_fread (&TMP_int,
                                          sizeof (INT_1D), 1, Grid_File);

        if (Surf_Grid_BC_Flag != NULL)
          Surf_Grid_BC_Flag[Index] = (INT_) TMP_int;
      }

      if (File_Format == UG_FIO_UNFORMATTED_DOUBLE ||
          File_Format == UG_FIO_UNFORMATTED_SINGLE)
        Read_Flag = Read_Flag + ug_fread (&Number_of_Bytes,
                                          sizeof (INT_), 1, Grid_File);

      Number_of_Read_Items = Number_of_Surf_Faces
                           + Special_Read_Items + Special_Read_Items;

      if (Read_Flag == Number_of_Read_Items)
        Read_Flag = 1;
      else
        Read_Flag = 0;
    }

    if (Read_Flag == 1)
    {
      Read_Flag = 0;

      if (File_Format == UG_FIO_UNFORMATTED_DOUBLE ||
          File_Format == UG_FIO_UNFORMATTED_SINGLE)
        Read_Flag = Read_Flag + ug_fread (&Number_of_Bytes,
                                          sizeof (INT_), 1, Grid_File);

      if (File_Format == UG_FIO_UNFORMATTED_SINGLE ||
          File_Format == UG_FIO_BINARY_SINGLE)
      {
        TMP_float = fc0;

        for (Index = 1; Index <= Number_of_Nodes; ++Index)
        {
          Read_Flag = Read_Flag
                    + ug_fread (&TMP_float, sizeof (float), 1, Grid_File);
 
          if (Initial_Normal_Spacing != NULL)
            Initial_Normal_Spacing[Index] = (double) TMP_float;
        }
      }
      else
      {
        TMP_double = dc0;

        for (Index = 1; Index <= Number_of_Nodes; ++Index)
        {
          Read_Flag = Read_Flag
                    + ug_fread (&TMP_double, sizeof (double), 1, Grid_File);
 
          if (Initial_Normal_Spacing != NULL)
            Initial_Normal_Spacing[Index] = (double) TMP_double;
        }
      }

      if (File_Format == UG_FIO_UNFORMATTED_DOUBLE ||
          File_Format == UG_FIO_UNFORMATTED_SINGLE)
        Read_Flag = Read_Flag + ug_fread (&Number_of_Bytes,
                                          sizeof (INT_), 1, Grid_File);

      Number_of_Read_Items = Number_of_Surf_Faces
                           + Special_Read_Items + Special_Read_Items;

      if (Read_Flag == Number_of_Read_Items)
        Read_Flag = 1;
      else
        Read_Flag = 0;
    }

    if (Read_Flag == 1)
    {
      Read_Flag = 0;

      if (File_Format == UG_FIO_UNFORMATTED_DOUBLE ||
          File_Format == UG_FIO_UNFORMATTED_SINGLE)
        Read_Flag = Read_Flag + ug_fread (&Number_of_Bytes,
                                          sizeof (INT_), 1, Grid_File);

      if (File_Format == UG_FIO_UNFORMATTED_SINGLE ||
          File_Format == UG_FIO_BINARY_SINGLE)
      {
        TMP_float = fc0;

        for (Index = 1; Index <= Number_of_Nodes; ++Index)
        {
          Read_Flag = Read_Flag
                    + ug_fread (&TMP_float, sizeof (float), 1, Grid_File);
 
          if (BL_Thickness != NULL)
            BL_Thickness[Index] = (double) TMP_float;
        }
      }
      else
      {
        TMP_double = dc0;

        for (Index = 1; Index <= Number_of_Nodes; ++Index)
        {
          Read_Flag = Read_Flag
                    + ug_fread (&TMP_double, sizeof (double), 1, Grid_File);
 
          if (BL_Thickness!= NULL)
            BL_Thickness[Index] = (double) TMP_double;
        }
      }

      if (File_Format == UG_FIO_UNFORMATTED_DOUBLE ||
          File_Format == UG_FIO_UNFORMATTED_SINGLE)
        Read_Flag = Read_Flag + ug_fread (&Number_of_Bytes,
                                          sizeof (INT_), 1, Grid_File);

      Number_of_Read_Items = Number_of_Surf_Faces
                           + Special_Read_Items + Special_Read_Items;

      if (Read_Flag == Number_of_Read_Items)
        Read_Flag = 1;
      else
        Read_Flag = 0;
    }
  }

  return;

}
