#include "UG3_LIB.h"

/*
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_qvlr.c,v 1.9 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

double ug3_qvlr (
  INT_ mscale,
  double x11,
  double x12,
  double x13,
  double x21,
  double x22,
  double x23,
  double x31,
  double x32,
  double x33,
  double x41,
  double x42,
  double x43)
{

  // Determine tet volume-length to edge-length ratio function, q.

  double chsq, cq, dx1, dx2, dx3, ls, ls_min, lsum, q, vol;

  cq = 432.0;

  dx1 = x21 - x11;
  dx2 = x22 - x12;
  dx3 = x23 - x13;

  ls = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  lsum = ls;

  ls_min = ls;

  dx1 = x31 - x11;
  dx2 = x32 - x12;
  dx3 = x33 - x13;

  ls = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  lsum = lsum + ls;

  ls_min = MIN (ls_min, ls);

  dx1 = x31 - x21;
  dx2 = x32 - x22;
  dx3 = x33 - x23;

  ls = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  lsum = lsum + ls;

  ls_min = MIN (ls_min, ls);

  dx1 = x41 - x11;
  dx2 = x42 - x12;
  dx3 = x43 - x13;

  ls = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  lsum = lsum + ls;

  ls_min = MIN (ls_min, ls);

  dx1 = x41 - x21;
  dx2 = x42 - x22;
  dx3 = x43 - x23;

  ls = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  lsum = lsum + ls;

  ls_min = MIN (ls_min, ls);

  dx1 = x41 - x31;
  dx2 = x42 - x32;
  dx3 = x43 - x33;

  ls = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  lsum = lsum + ls;

  ls_min = MIN (ls_min, ls);

  vol = ug3_vol (x11, x12, x13, x21, x22, x23, x31, x32, x33, x41, x42, x43);

  lsum = lsum - ls_min;

  chsq = (mscale) ? (lsum / 5.0) / ls_min: 1.0;

  q = chsq * cq * vol * vol;
  q = pow (q, 1.0/3.0);
  q = q / (lsum + chsq * ls_min);

  return (q);
}

double ug3_tet_qvlr (
  INT_ inode1,
  INT_ inode2,
  INT_ inode3,
  INT_ inode4,
  INT_ mscale,
  DOUBLE_3D * x)
{

  // Determine tet volume-length to edge-length ratio function, q.

  return (ug3_qvlr (mscale,
                    x[inode1][0], x[inode1][1], x[inode1][2],
                    x[inode2][0], x[inode2][1], x[inode2][2],
                    x[inode3][0], x[inode3][1], x[inode3][2],
                    x[inode4][0], x[inode4][1], x[inode4][2]));
}

double ug3_pyramid_qvlr (
  INT_ inode1,
  INT_ inode2,
  INT_ inode3,
  INT_ inode4,
  INT_ inode5,
  INT_ mscale,
  DOUBLE_3D * x)
{

  // Determine pyramid volume-length to edge-length ratio function, q.

  double chsq, cq, dx1, dx2, dx3, ls, ls_min, lsum, q, vol,
         x11, x12, x13,
         x21, x22, x23,
         x31, x32, x33,
         x41, x42, x43,
         x51, x52, x53;

  cq = 256.0;

  x11 = x[inode1][0];
  x12 = x[inode1][1];
  x13 = x[inode1][2];
  x21 = x[inode2][0];
  x22 = x[inode2][1];
  x23 = x[inode2][2];
  x31 = x[inode3][0];
  x32 = x[inode3][1];
  x33 = x[inode3][2];
  x41 = x[inode4][0];
  x42 = x[inode4][1];
  x43 = x[inode4][2];
  x51 = x[inode5][0];
  x52 = x[inode5][1];
  x53 = x[inode5][2];

  dx1 = x31 - x11;
  dx2 = x32 - x12;
  dx3 = x33 - x13;

  ls = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  lsum = ls;

  ls_min = ls;

  dx1 = x31 - x21;
  dx2 = x32 - x22;
  dx3 = x33 - x23;

  ls = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  lsum = lsum + ls;

  ls_min = MIN (ls_min, ls);

  dx1 = x41 - x31;
  dx2 = x42 - x32;
  dx3 = x43 - x33;

  ls = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  lsum = lsum + ls;

  ls_min = MIN (ls_min, ls);

  dx1 = x51 - x31;
  dx2 = x52 - x32;
  dx3 = x53 - x33;

  ls = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  lsum = lsum + ls;

  ls_min = MIN (ls_min, ls);

  dx1 = x21 - x11;
  dx2 = x22 - x12;
  dx3 = x23 - x13;

  ls = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  lsum = lsum + ls;

  ls_min = MIN (ls_min, ls);

  dx1 = x41 - x11;
  dx2 = x42 - x12;
  dx3 = x43 - x13;

  ls = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  lsum = lsum + ls;

  ls_min = MIN (ls_min, ls);

  dx1 = x51 - x21;
  dx2 = x52 - x22;
  dx3 = x53 - x23;

  ls = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  lsum = lsum + ls;

  ls_min = MIN (ls_min, ls);

  dx1 = x51 - x41;
  dx2 = x52 - x42;
  dx3 = x53 - x43;

  ls = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  lsum = lsum + ls;

  ls_min = MIN (ls_min, ls);

  vol = ug3_pyramid_vol (inode1, inode2, inode3, inode4, inode5, x);

  lsum = lsum - ls_min;

  chsq = (mscale) ? (lsum / 7.0) / ls_min: 1.0;

  q = chsq * cq * vol * vol;
  q = pow (q, 1.0/3.0);
  q = q / (lsum + chsq * ls_min);

  return (q);
}

double ug3_prism_qvlr (
  INT_ inode1,
  INT_ inode2,
  INT_ inode3,
  INT_ inode4,
  INT_ inode5,
  INT_ inode6,
  INT_ mscale,
  DOUBLE_3D * x)
{

  // Determine the prism volume-length to edge-length ratio function, q.

  double chsq, cq, dx1, dx2, dx3, lsum1, lsum2, lsum3, q, vol,
         x11, x12, x13,
         x21, x22, x23,
         x31, x32, x33,
         x41, x42, x43,
         x51, x52, x53,
         x61, x62, x63;

  cq = 108.0;

  x11 = x[inode1][0];
  x12 = x[inode1][1];
  x13 = x[inode1][2];
  x21 = x[inode2][0];
  x22 = x[inode2][1];
  x23 = x[inode2][2];
  x31 = x[inode3][0];
  x32 = x[inode3][1];
  x33 = x[inode3][2];
  x41 = x[inode4][0];
  x42 = x[inode4][1];
  x43 = x[inode4][2];
  x51 = x[inode5][0];
  x52 = x[inode5][1];
  x53 = x[inode5][2];
  x61 = x[inode6][0];
  x62 = x[inode6][1];
  x63 = x[inode6][2];

  dx1 = x21 - x11;
  dx2 = x22 - x12;
  dx3 = x23 - x13;

  lsum1 = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  dx1 = x31 - x11;
  dx2 = x32 - x12;
  dx3 = x33 - x13;

  lsum1 = lsum1 + dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  dx1 = x31 - x21;
  dx2 = x32 - x22;
  dx3 = x33 - x23;

  lsum1 = lsum1 + dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  dx1 = x51 - x41;
  dx2 = x52 - x42;
  dx3 = x53 - x43;

  lsum2 = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  dx1 = x61 - x41;
  dx2 = x62 - x42;
  dx3 = x63 - x43;

  lsum2 = lsum2 + dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  dx1 = x61 - x51;
  dx2 = x62 - x52;
  dx3 = x63 - x53;

  lsum2 = lsum2 + dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  dx1 = x41 - x11;
  dx2 = x42 - x12;
  dx3 = x43 - x13;

  lsum3 = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  dx1 = x51 - x21;
  dx2 = x52 - x22;
  dx3 = x53 - x23;

  lsum3 = lsum3 + dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  dx1 = x61 - x31;
  dx2 = x62 - x32;
  dx3 = x63 - x33;

  lsum3 = lsum3 + dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  vol = ug3_prism_vol (inode1, inode2, inode3, inode4, inode5, inode6, x);

  chsq = (mscale) ? 0.5 * (lsum1 + lsum2) / lsum3: 1.0;

  q = chsq * cq * vol * vol;
  q = pow (q, 1.0/3.0);
  q = q / (lsum1 + lsum2 + chsq * lsum3);

  return (q);
}

double ug3_hex_qvlr (
  INT_ inode1,
  INT_ inode2,
  INT_ inode3,
  INT_ inode4,
  INT_ inode5,
  INT_ inode6,
  INT_ inode7,
  INT_ inode8,
  INT_ mscale,
  DOUBLE_3D * x)
{

  // Determine the hex volume-length to edge-length ratio function, q.

  double chsq, cq, dx1, dx2, dx3, lsum1, lsum2, lsum3, q, vol,
         x11, x12, x13,
         x21, x22, x23,
         x31, x32, x33,
         x41, x42, x43,
         x51, x52, x53,
         x61, x62, x63,
         x71, x72, x73,
         x81, x82, x83;

  cq = 48.0;

  x11 = x[inode1][0];
  x12 = x[inode1][1];
  x13 = x[inode1][2];
  x21 = x[inode2][0];
  x22 = x[inode2][1];
  x23 = x[inode2][2];
  x31 = x[inode3][0];
  x32 = x[inode3][1];
  x33 = x[inode3][2];
  x41 = x[inode4][0];
  x42 = x[inode4][1];
  x43 = x[inode4][2];
  x51 = x[inode5][0];
  x52 = x[inode5][1];
  x53 = x[inode5][2];
  x61 = x[inode6][0];
  x62 = x[inode6][1];
  x63 = x[inode6][2];
  x71 = x[inode7][0];
  x72 = x[inode7][1];
  x73 = x[inode7][2];
  x81 = x[inode8][0];
  x82 = x[inode8][1];
  x83 = x[inode8][2];

  dx1 = x21 - x11;
  dx2 = x22 - x12;
  dx3 = x23 - x13;

  lsum1 = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  dx1 = x41 - x11;
  dx2 = x42 - x12;
  dx3 = x43 - x13;

  lsum1 = lsum1 + dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  dx1 = x31 - x21;
  dx2 = x32 - x22;
  dx3 = x33 - x23;

  lsum1 = lsum1 + dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  dx1 = x41 - x31;
  dx2 = x42 - x32;
  dx3 = x43 - x33;

  lsum1 = lsum1 + dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  dx1 = x61 - x51;
  dx2 = x62 - x52;
  dx3 = x63 - x53;

  lsum2 = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  dx1 = x81 - x51;
  dx2 = x82 - x52;
  dx3 = x83 - x53;

  lsum2 = lsum2 + dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  dx1 = x71 - x61;
  dx2 = x72 - x62;
  dx3 = x73 - x63;

  lsum2 = lsum2 + dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  dx1 = x81 - x71;
  dx2 = x82 - x72;
  dx3 = x83 - x73;

  lsum2 = lsum2 + dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  dx1 = x51 - x11;
  dx2 = x52 - x12;
  dx3 = x53 - x13;

  lsum3 = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  dx1 = x61 - x21;
  dx2 = x62 - x22;
  dx3 = x63 - x23;

  lsum3 = lsum3 + dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  dx1 = x71 - x31;
  dx2 = x72 - x32;
  dx3 = x73 - x33;

  lsum3 = lsum3 + dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  dx1 = x81 - x41;
  dx2 = x82 - x42;
  dx3 = x83 - x43;

  lsum3 = lsum3 + dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

  vol = ug3_hex_vol (inode1, inode2, inode3, inode4,
                     inode5, inode6, inode7, inode8, x);

  chsq = (mscale) ? 0.5 * (lsum1 + lsum2) / lsum3: 1.0;

  q = chsq * cq * vol * vol;
  q = pow (q, 1.0/3.0);
  q = q / (lsum1 + lsum2 + chsq * lsum3);

  return (q);
}
