#include "UG3_LIB.h"

void ug3_qtria_recd
 (INT_ nbface,
  INT_ nnode,
  INT_1D * ibcibf,
  INT_3D * ibfibf,
  INT_1D * ibfin,
  INT_3D * inibf,
  INT_1D * iqibf,
  INT_1D * irfibf,
  INT_1D * mchkn,
  double angbd,
  double angbq,
  DOUBLE_3D * x)

{

/*
 * Reconnect tria surface faces derived from quad surface faces if they are
 * adjacent to discontinuities.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_qtria_recd.c,v 1.8 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ inode, inode1, inode2, inode3, inode4,
       ibface, ibface1, ibface2, ibface3, ibface4, ibfn2, ibfn3, ibfn4,
       iquad, jbface, kbface, loc, mfound;

  double a1231, a1232, a1233, a123s,
         a1341, a1342, a1343, a134s,
         cosbd, cosbds, cosbq, cosbqs, dc0, dc1, dc45,
         dx211, dx212, dx213,
         dx311, dx312, dx313,
         dx411, dx412, dx413, 
         w, w1, w2, w3, w123, w234, w341, w412,
         x11, x12, x13, x21, x22, x23, x31, x32, x33, x41, x42, x43;

  dc0 = 0.0;
  dc1 = 1.0;
  dc45 = 45.0;

  if (iqibf == NULL) return;

  cosbd = - cos (angbd * atan (dc1) / dc45);
  cosbds = cosbd * fabs (cosbd);
  cosbq = cos (angbq * atan (dc1) / dc45);
  cosbqs = cosbq * fabs (cosbq);

  for (inode = 1; inode <= nnode; ++inode)
  {
    ibfin[inode] = 0;

    mchkn[inode] = 0;
  }

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    if (CHK_BL_UG3_GBC (ibcibf[ibface]))
    {
      inode1 = inibf[ibface][0];
      inode2 = inibf[ibface][1];
      inode3 = inibf[ibface][2];

      ibfin[inode1] = ibface;
      ibfin[inode2] = ibface;
      ibfin[inode3] = ibface;
    }
  }

  for (inode = 1; inode <= nnode; ++inode)
  {
    ibface = ibfin[inode];

    if (ibface)
    {
      ibfn2 = (inibf[ibface][0] == inode) ? 1 :
              (inibf[ibface][1] == inode) ? 2 : 0;
      ibfn3 = (ibfn2 < 2) ? ibfn2 + 1 : 0;

      inode2 = inibf[ibface][ibfn2];
      inode3 = inibf[ibface][ibfn3];

      x11 = x[inode][0];
      x12 = x[inode][1];
      x13 = x[inode][2];
      x21 = x[inode2][0];
      x22 = x[inode2][1];
      x23 = x[inode2][2];
      x31 = x[inode3][0];
      x32 = x[inode3][1];
      x33 = x[inode3][2];

      dx211 = x21 - x11;
      dx212 = x22 - x12;
      dx213 = x23 - x13;
      dx311 = x31 - x11;
      dx312 = x32 - x12;
      dx313 = x33 - x13;

      a1231 = dx212 * dx313 - dx213 * dx312;
      a1232 = dx213 * dx311 - dx211 * dx313;
      a1233 = dx211 * dx312 - dx212 * dx311;
      a123s = a1231 * a1231 + a1232 * a1232 + a1233 * a1233;

      jbface = ibface;

      ibfn4 = ibfn3;

      dx411 = dx311;
      dx412 = dx312;
      dx413 = dx313;

      a1341 = a1231;
      a1342 = a1232;
      a1343 = a1233;
      a134s = a123s;

      kbface = ibface;

      loc = 0;

      do
      {
        ibface = jbface;

        ibfn2 = (ibfn4 > 0) ? ibfn4 - 1: 2;

        dx311 = dx411;
        dx312 = dx412;
        dx313 = dx413;

        a1231 = a1341;
        a1232 = a1342;
        a1233 = a1343;
        a123s = a134s;

        jbface = ibfibf[ibface][ibfn2];

        if (jbface)
        {
          ibfn4 = (ibfibf[jbface][0] == ibface) ? 0 :
                  (ibfibf[jbface][1] == ibface) ? 1 : 2;

          inode4 = inibf[jbface][ibfn4];

          x41 = x[inode4][0];
          x42 = x[inode4][1];
          x43 = x[inode4][2];

          dx411 = x41 - x11;
          dx412 = x42 - x12;
          dx413 = x43 - x13;

          a1341 = dx312 * dx413 - dx313 * dx412;
          a1342 = dx313 * dx411 - dx311 * dx413;
          a1343 = dx311 * dx412 - dx312 * dx411;
          a134s = a1341 * a1341 + a1342 * a1342 + a1343 * a1343;

          w = a1231 * a1341 + a1232 * a1342 + a1233 * a1343;
          w = w * fabs (w) - cosbds * a123s * a134s;

          if (w <= dc0) ++(mchkn[inode]);
        }

        ++loc;
      }
      while (loc <= nbface && jbface != kbface && jbface);
    }
  }

  mfound = 0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    if (mchkn[inode] >= 3)
    {
      mfound = 1;

      mchkn[inode] = 1;
    }
    else
      mchkn[inode] = 0;
  }

  if (mfound == 0)
    return;

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    iquad = iqibf[ibface];

    if (iquad > 0 && CHK_BL_UG3_GBC (ibcibf[ibface]))
    {
      ibface1 = ibfibf[ibface][0];
      ibface2 = ibfibf[ibface][1];
      ibface3 = ibfibf[ibface][2];

      if (iquad == iqibf[ibface1])
      {
        jbface = ibface1;

        ibface1 = ibface3;
        ibface4 = ibface2;

        inode1 = inibf[ibface][2];
        inode2 = inibf[ibface][0];
        inode3 = inibf[ibface][1];
      }
      else if (iquad == iqibf[ibface2])
      {
        jbface = ibface2;

        ibface4 = ibface3;

        inode1 = inibf[ibface][0];
        inode2 = inibf[ibface][1];
        inode3 = inibf[ibface][2];
      }
      else //if (iquad == iqibf[ibface3])
      {
        jbface = ibface3;

        ibface4 = ibface1;
        ibface1 = ibface2;

        inode1 = inibf[ibface][1];
        inode2 = inibf[ibface][2];
        inode3 = inibf[ibface][0];
      }

      if (jbface > ibface && (mchkn[inode1] || mchkn[inode3]))
      {
        if (ibface == ibfibf[jbface][0])
        {
          ibface2 = ibfibf[jbface][1];
          ibface3 = ibfibf[jbface][2];

          inode4 = inibf[jbface][0];
        }
        else if (ibface == ibfibf[jbface][1])
        {
          ibface2 = ibfibf[jbface][2];
          ibface3 = ibfibf[jbface][0];

          inode4 = inibf[jbface][1];
        }
        else //if (ibface == ibfibf[jbface][2])
        {
          ibface2 = ibfibf[jbface][0];
          ibface3 = ibfibf[jbface][1];

          inode4 = inibf[jbface][2];
        }

        if (ibface1 && ibface2 && ibface3 && ibface4 &&
            mchkn[inode2] == 0 && mchkn[inode4] == 0)
        {
          ug3_face_ang_w (inode1, inode2, inode3, &w1, &w2, &w3, &w123, x);
          ug3_face_ang_w (inode3, inode4, inode1, &w1, &w2, &w3, &w341, x);
          ug3_face_ang_w (inode2, inode3, inode4, &w1, &w2, &w3, &w234, x);
          ug3_face_ang_w (inode4, inode1, inode2, &w1, &w2, &w3, &w412, x);

          w1 = MIN (w123, w341);
          w2 = MIN (w234, w412);

          if (w2 >= w1 || w2 >= cosbqs)
          {
            inibf[ibface][0] = inode2;
            inibf[ibface][1] = inode3;
            inibf[ibface][2] = inode4;

            inibf[jbface][0] = inode4;
            inibf[jbface][1] = inode1;
            inibf[jbface][2] = inode2;

            ibfibf[ibface][0] = ibface2;
            ibfibf[ibface][1] = jbface;
            ibfibf[ibface][2] = ibface1;

            ibfibf[jbface][0] = ibface4;
            ibfibf[jbface][1] = ibface;
            ibfibf[jbface][2] = ibface3;

            if (ibfibf[ibface2][0] == jbface)
               ibfibf[ibface2][0] = ibface;
            else if (ibfibf[ibface2][1] == jbface)
               ibfibf[ibface2][1] = ibface;
            else //if (ibfibf[ibface2][2] == jbface)
               ibfibf[ibface2][2] = ibface;

            if (ibfibf[ibface4][0] == ibface)
               ibfibf[ibface4][0] = jbface;
            else if (ibfibf[ibface4][1] == ibface)
               ibfibf[ibface4][1] = jbface;
            else //if (ibfibf[ibface4][2] == ibface)
               ibfibf[ibface4][2] = jbface;

            if (irfibf)
            {
              irfibf[ibface] = 7;
              irfibf[jbface] = 7;
            }
          }
        }
      }
    }
  }

  return;

}
