#include "UG3_LIB.h"

INT_ ug3_qtria
 (INT_ mmiqibf,
  INT_ mqbl,
  INT_ *nbface,
  INT_ *nquad,
  INT_1D ** ibcibf_ptr,
  INT_1D ** idibf_ptr,
  INT_1D ** ierribf_ptr,
  INT_3D ** inibf_ptr,
  INT_4D * iniq,
  INT_1D ** iqibf_ptr,
  INT_1D ** irfibf_ptr,
  DOUBLE_3D * x)

{

/*
 * Replace quad surface faces with tria surface faces.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_qtria.c,v 1.41 2022/11/11 14:39:49 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_1D *ibcibf, *ibciq, *idibf, *idiq, *iqibf, *irfibf, *nfpn;
  INT_3D *inibf;

  INT_ Error_Flag, ibc, ibface, id, inode, inode1, inode2, inode3, inode4,
       iquad, jquad, mibcibf, midibf, mierribf, miqibf, mirfibf,
       nbfacem, nfpn1, nfpn2, nfpn3, nfpn4, nfpnmin, nnodem;

  double a1231, a1232, a1233, a123s,
         a2341, a2342, a2343, a234s,
         a3411, a3412, a3413, a341s,
         a4121, a4122, a4123, a412s,
         dc0, dc1,
         dx211, dx212, dx213,
         dx321, dx322, dx323,
         dx411, dx412, dx413,
         dx431, dx432, dx433,
         w, w123, w1min, w234, w2min, w341, w412, wmin,
         x11, x12, x13, x21, x22, x23, x31, x32, x33, x41, x42, x43;

  dc0 = 0.0;
  dc1 = 1.0;

  wmin = 0.001; // 90+/-1.8 deg  (wmin = 1/tan^2[max_angle])

  if (*nquad == 0)
    return (0);

  inibf = *inibf_ptr;

  nnodem = 0;

  for (ibface = 1; ibface <= *nbface; ++ibface)
  {
    inode1 = inibf[ibface][0];
    inode2 = inibf[ibface][1];
    inode3 = inibf[ibface][2];

    nnodem = MAX (nnodem, inode1);
    nnodem = MAX (nnodem, inode2);
    nnodem = MAX (nnodem, inode3);
  }

  for (iquad = 1; iquad <= *nquad; ++iquad)
  {
    inode1 = iniq[iquad][0];
    inode2 = iniq[iquad][1];
    inode3 = iniq[iquad][2];
    inode4 = iniq[iquad][3];

    nnodem = MAX (nnodem, inode1);
    nnodem = MAX (nnodem, inode2);
    nnodem = MAX (nnodem, inode3);
    nnodem = MAX (nnodem, inode4);
  }

  nbfacem = *nbface + (*nquad) + (*nquad);

  mibcibf = (*ibcibf_ptr == NULL) ? 0 : 1;
  midibf = (*idibf_ptr == NULL) ? 0 : 1;
  mierribf = (*ierribf_ptr == NULL) ? 0 : 1;
  miqibf = (*iqibf_ptr == NULL && mmiqibf != 1) ? 0 : 1;
  mirfibf = (*irfibf_ptr == NULL) ? 0 : 1;

  Error_Flag = 0;

  if (mibcibf)
  {
    *ibcibf_ptr = (INT_1D *) ug_realloc (&Error_Flag, *ibcibf_ptr,
                                         (nbfacem+1) * sizeof (INT_1D));
    ibciq = (INT_1D *) ug_malloc (&Error_Flag, (*nquad+1) * sizeof (INT_1D));
  }
  if (midibf)
  {
    *idibf_ptr = (INT_1D *) ug_realloc (&Error_Flag, *idibf_ptr,
                                        (nbfacem+1) * sizeof (INT_1D));
    idiq = (INT_1D *) ug_malloc (&Error_Flag, (*nquad+1) * sizeof (INT_1D));
  }
  if (mierribf)
    *ierribf_ptr = (INT_1D *) ug_realloc (&Error_Flag, *ierribf_ptr,
                                          (nbfacem+1) * sizeof (INT_1D));
  if (miqibf)
    *iqibf_ptr = (INT_1D *) ug_realloc (&Error_Flag, *iqibf_ptr,
                                        (nbfacem+1) * sizeof (INT_1D));
  if (mirfibf)
    *irfibf_ptr = (INT_1D *) ug_realloc (&Error_Flag, *irfibf_ptr,
                                         (nbfacem+1) * sizeof (INT_1D));

  *inibf_ptr = (INT_3D *) ug_realloc (&Error_Flag, *inibf_ptr,
                                      (nbfacem+1) * sizeof (INT_3D));

  nfpn = (INT_1D *) ug_malloc (&Error_Flag, (nnodem+1) * sizeof (INT_1D));
                                         
  if (Error_Flag > 0)
  {
    ug_error_message ("*** ERROR 100300 : unable to allocate required memory ***");
    return (100300);
  }

  ibcibf = *ibcibf_ptr;
  idibf = *idibf_ptr;
  iqibf = *iqibf_ptr;
  irfibf = *irfibf_ptr;

  inibf = *inibf_ptr;

  if (miqibf)
  {
    for (ibface = 1; ibface <= nbfacem; ++ibface)
    {
      iqibf[ibface] = 0;
    }
  }

  if (mibcibf)
  {
    jquad = 0;

    iquad = *nquad;

    do
    {
      if (ibcibf[*nbface+iquad] == FIXED_BL_INT_UG3_GBC)
        jquad = iquad+1;

      --iquad;
    }
    while (iquad >= 1 && jquad == 0);

    // move all surfaces that are not fixed and don't intersect the BL region to
    // the end of quad-face data

    if (jquad)
    {
      for (iquad = 1; iquad <= *nquad; ++iquad)
      {
        ibc = ibcibf[*nbface+iquad];

        if (iquad < jquad && ibc != FIXED_BL_INT_UG3_GBC)
        {
          do
          {
            --jquad;
          }
          while (iquad < jquad && ibcibf[*nbface+jquad] != FIXED_BL_INT_UG3_GBC);

          if (iquad < jquad)
          {
            ibcibf[*nbface+iquad] = ibcibf[*nbface+jquad];
            ibcibf[*nbface+jquad] = ibc;

            if (midibf)
            {
              id = idibf[*nbface+iquad];

              idibf[*nbface+iquad] = idibf[*nbface+jquad];
              idibf[*nbface+jquad] = id;
            }

            if (mirfibf)
            {
              irfibf[*nbface+iquad] = 0;
              irfibf[*nbface+jquad] = 0;
            }

            inode1 = iniq[iquad][0];
            inode2 = iniq[iquad][1];
            inode3 = iniq[iquad][2];
            inode4 = iniq[iquad][3];

            iniq[iquad][0] = iniq[jquad][0];
            iniq[iquad][1] = iniq[jquad][1];
            iniq[iquad][2] = iniq[jquad][2];
            iniq[iquad][3] = iniq[jquad][3];

            iniq[jquad][0] = inode1;
            iniq[jquad][1] = inode2;
            iniq[jquad][2] = inode3;
            iniq[jquad][3] = inode4;
          }
        }
      }
    }
  }

  for (inode = 1; inode <= nnodem; ++inode)
  {
    nfpn[inode] = 0;
  }

  for (ibface = 1; ibface <= *nbface; ++ibface)
  {
    inode1 = inibf[ibface][0];
    inode2 = inibf[ibface][1];
    inode3 = inibf[ibface][2];

    ++(nfpn[inode1]);
    ++(nfpn[inode2]);
    ++(nfpn[inode3]);
  }

  for (iquad = 1; iquad <= *nquad; ++iquad)
  {
    inode1 = iniq[iquad][0];
    inode2 = iniq[iquad][1];
    inode3 = iniq[iquad][2];
    inode4 = iniq[iquad][3];

    ++(nfpn[inode1]);
    ++(nfpn[inode2]);
    ++(nfpn[inode3]);
    ++(nfpn[inode4]);
  }

  if (mibcibf)
  {
    for (iquad = 1; iquad <= *nquad; ++iquad)
    {
      ibciq[iquad] = ibcibf[*nbface+iquad];
    }
  }

  if (midibf)
  {
    for (iquad = 1; iquad <= *nquad; ++iquad)
    {
      idiq[iquad] = idibf[*nbface+iquad];
    }
  }

  ibface = *nbface;

  jquad = 0;

  for (iquad = 1; iquad <= *nquad; ++iquad)
  {
    ibc = (mibcibf) ? ibciq[iquad]: 0;

    if (mqbl == 0 || ibc == FIXED_BL_INT_UG3_GBC || CHK_BL_UG3_GBC (ibc))
    {
      inode1 = iniq[iquad][0];
      inode2 = iniq[iquad][1];
      inode3 = iniq[iquad][2];
      inode4 = iniq[iquad][3];

      nfpn1 = nfpn[inode1];
      nfpn2 = nfpn[inode2];
      nfpn3 = nfpn[inode3];
      nfpn4 = nfpn[inode4];

      nfpnmin = MIN (nfpn1, nfpn2);
      nfpnmin = MIN (nfpnmin, nfpn3);
      nfpnmin = MIN (nfpnmin, nfpn4);

      if (nfpnmin > 1)
      {
        x11 = x[inode1][0];
        x12 = x[inode1][1];
        x13 = x[inode1][2];
        x21 = x[inode2][0];
        x22 = x[inode2][1];
        x23 = x[inode2][2];
        x31 = x[inode3][0];
        x32 = x[inode3][1];
        x33 = x[inode3][2];
        x41 = x[inode4][0];
        x42 = x[inode4][1];
        x43 = x[inode4][2];

        dx211 = x21 - x11;
        dx212 = x22 - x12;
        dx213 = x23 - x13;
        dx321 = x31 - x21;
        dx322 = x32 - x22;
        dx323 = x33 - x23;
        dx411 = x41 - x11;
        dx412 = x42 - x12;
        dx413 = x43 - x13;
        dx431 = x41 - x31;
        dx432 = x42 - x32;
        dx433 = x43 - x33;

        a1231 = dx212 * dx323 - dx213 * dx322;
        a1232 = dx213 * dx321 - dx211 * dx323;
        a1233 = dx211 * dx322 - dx212 * dx321;

        a123s = a1231 * a1231 + a1232 * a1232 + a1233 * a1233;

        a3411 = dx412 * dx433 - dx413 * dx432;
        a3412 = dx413 * dx431 - dx411 * dx433;
        a3413 = dx411 * dx432 - dx412 * dx431;

        a341s = a3411 * a3411 + a3412 * a3412 + a3413 * a3413;

        a2341 = dx322 * dx433 - dx323 * dx432;
        a2342 = dx323 * dx431 - dx321 * dx433;
        a2343 = dx321 * dx432 - dx322 * dx431;

        a234s = a2341 * a2341 + a2342 * a2342 + a2343 * a2343;

        a4121 = dx212 * dx413 - dx213 * dx412;
        a4122 = dx213 * dx411 - dx211 * dx413;
        a4123 = dx211 * dx412 - dx212 * dx411;

        a412s = a4121 * a4121 + a4122 * a4122 + a4123 * a4123;

        if (a123s == dc0 || a341s == dc0)
        {
          w = dc1;

          w1min = dc0;
          w2min = dc1;
        }

        else if (a234s == dc0 || a412s == dc0)
        {
          w = dc1;

          w1min = dc1;
          w2min = dc0;
        }

        else
        {
          w123 = - dx321 * dx211 - dx322 * dx212 - dx323 * dx213;
          w341 =   dx411 * dx431 + dx412 * dx432 + dx413 * dx433;
          w234 = - dx431 * dx321 - dx432 * dx322 - dx433 * dx323;
          w412 =   dx211 * dx411 + dx212 * dx412 + dx213 * dx413;

          w123 = w123 * fabs (w123) / a123s;
          w341 = w341 * fabs (w341) / a341s;
          w234 = w234 * fabs (w234) / a234s;
          w412 = w412 * fabs (w412) / a412s;

          w1min = MIN (w123, w341);  
          w2min = MIN (w234, w412);

          w = MAX (fabs (w1min), fabs (w2min));
        }
      }
      else
      {
        w = dc1;

        if (nfpn1 || nfpn3)
        {
          w1min = dc1;
          w2min = dc0;
        }
        else
        {
          w1min = dc0;
          w2min = dc1;
        }
      }

      if (w1min >= w2min || w <= wmin)
      {
        ++ibface;

        inibf[ibface][0] = inode1;
        inibf[ibface][1] = inode2;
        inibf[ibface][2] = inode3;

        ++ibface;

        inibf[ibface][0] = inode3;
        inibf[ibface][1] = inode4;
        inibf[ibface][2] = inode1;
      }

      else
      {
        ++ibface;

        inibf[ibface][0] = inode2;
        inibf[ibface][1] = inode3;
        inibf[ibface][2] = inode4;

        ++ibface;

        inibf[ibface][0] = inode4;
        inibf[ibface][1] = inode1;
        inibf[ibface][2] = inode2;
      }

      if (miqibf)
      {
        if (mibcibf && CHK_BL_UG3_GBC (ibc) && CHK_TRANSP_UG3_GBC (ibc))
        {
          iqibf[ibface-1] = 0;
          iqibf[ibface] = 0;
        }
        else
        {
          iqibf[ibface-1] = iquad;
          iqibf[ibface] = iquad;
        }

      }

      if (mibcibf)
      {
        ibcibf[ibface-1] = ibc;
        ibcibf[ibface] = ibc;
      }

      if (midibf)
      {
        id = idiq[iquad];

        idibf[ibface-1] = id;
        idibf[ibface] = id;
      }

      if (mirfibf)
      {
        irfibf[ibface-1] = 5;
        irfibf[ibface] = 5;
      }
    }
    else
    {
      ++jquad;

      if (mibcibf)
        ibciq[jquad] = ibciq[iquad];

      if (midibf)
        idiq[jquad] = idiq[iquad];

      iniq[jquad][0] = iniq[iquad][0];
      iniq[jquad][1] = iniq[iquad][1];
      iniq[jquad][2] = iniq[iquad][2];
      iniq[jquad][3] = iniq[iquad][3];
    }
  }

  *nbface = ibface;

  *nquad = jquad;

  for (iquad = 1; iquad <= *nquad; ++iquad)
  {
    if (mibcibf)
      ibcibf[*nbface+iquad] = ibciq[iquad];

    if (midibf)
      idibf[*nbface+iquad] = idiq[iquad];

    if (mirfibf)
      irfibf[*nbface+iquad] = 0;
  }

  if (mierribf)
    ug_set_int (1, *nbface, 0, *ierribf_ptr);

  ug_free (nfpn);
  if (mibcibf) ug_free (ibciq);
  if (midibf) ug_free (idiq);

  return (0);

}
