#include "UG3_LIB.h"

INT_ ug3_qchkb_initialize_param (UG_Param_Struct * Param_Struct_Ptr)
{

/*
 * Set the name, flag, default value, minimum allowable value, maximum allowable
 * value and description for all QCHK-boundary parameters.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_qchkb_initialize_param.c,v 1.8 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ierr;

  // set int params

  ierr = ug_set_int_param_struct ("mqchkb", "",
   "Boundary surface quality measure information output flag.",
   "\
If mqchkb = 0, then do not generate boundary surface quality measure information. ; \
If mqchkb = 1, then generate boundary surface  quality measure information. \
   ",
   4, 0, 1, 0, 1, Param_Struct_Ptr);

  if (ierr) return (ierr);

  ierr = ug_set_int_param_struct ("m_arearchk", "",
   "Output area ratio check flag.",
   "\
If m_arearchk = 0, then do not check area ratio between faces. ; \
If m_arearchk = 1, then check area ratio between faces. \
   ",
   4, 0, 0, 0, 1, Param_Struct_Ptr);

  if (ierr) return (ierr);

  // set double params

  ierr = ug_set_double_param_struct ("ang_qbmax", "",
   "Output face angle check maximum angle limit.",
"\
Typical maximum angle for a good quality boundary surface. \
   ",
   4, 0, 120.0, 60.0, 180.0, Param_Struct_Ptr);

  if (ierr) return (ierr);

  ierr = ug_set_double_param_struct ("ang_qbmax2", "",
   "Output face angle check usable maximum angle limit.",
"\
Typical maximum angle for a usable boundary surface mesh. \
   ",
   4, 0, 170.0, 60.0, 180.0, Param_Struct_Ptr);

  if (ierr) return (ierr);

  ierr = ug_set_double_param_struct ("ang_qbmin", "",
   "Output face angle check minimum angle limit.",
"\
Typical minimum angle for a good quality boundary surface. \
   ",
   4, 0, 10.0, 0.0, 60.0, Param_Struct_Ptr);

  if (ierr) return (ierr);

  ierr = ug_set_double_param_struct ("qarear_qmin", "",
   "Output quality function Q check quality limit.",
"\
Typical minimum quality function q for good quaility elements. \
   ",
   4, 0, 0.1, 0.0, 1.0, Param_Struct_Ptr);

  if (ierr) return (ierr);

  ierr = ug_set_double_param_struct ("qarear_qmin2", "",
   "Output quality function Q check usable limit.",
"\
Typical minimum quality function q for a usable volume mesh. \
   ",
   4, 0, 0.01, 0.0, 1.0, Param_Struct_Ptr);

  if (ierr) return (ierr);

  ierr = ug_set_double_param_struct ("arear_qbmin", "",
   "Output area ratio check quality limit.",
"\
Typical minimum volume ratio for good quaility elements. \
   ",
   4, 0, 0.1, 0.0, 1.0, Param_Struct_Ptr);

  if (ierr) return (ierr);

  ierr = ug_set_double_param_struct ("arear_qbmin2", "",
   "Output area ratio check quality limit.",
"\
Typical minimum volume ratio for a usable surface mesh. \
   ",
   4, 0, 0.01, 0.0, 1.0, Param_Struct_Ptr);

  if (ierr) return (ierr);

  // set default values

  ug_set_param_def (Param_Struct_Ptr);

  return (0);
}
