#include "UG3_LIB.h"

INT_ ug3_qchkb (int argc,
                char *argv[],
                INT_ nbface,
                INT_ nquad,
                INT_3D * inibf,
                INT_4D * iniq,
                DOUBLE_3D * x)
{
  // Check and output boundary surface mesh quality information.

  UG_Param_Struct * Param_Struct_Ptr;

  INT_ ierr;

  // malloc and set parameter structure arrays

  ierr = ug_malloc_param (&Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug3_qchkb_initialize_param (Param_Struct_Ptr);

  if (ierr == 0)
    ug_set_params_from_arg (argv, argc, 1, 0, Param_Struct_Ptr);

  // check and output boundary surface mesh quality information

  if (ierr == 0)
    ug3_qchkb2 (nbface, nquad, inibf, iniq, x, Param_Struct_Ptr);

  ug_free_param (Param_Struct_Ptr);

  return ierr;
}

void ug3_qchkb2 (INT_ nbface,
                 INT_ nquad,
                 INT_3D * inibf,
                 INT_4D * iniq,
                 DOUBLE_3D * x,
                 UG_Param_Struct * Param_Struct_Ptr)
{

/*
 * Check and output boundary surface mesh quality information.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_qchkb.c,v 1.7 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ iget;
  INT_ mqchkb = 1;

  double ang_qbmax, ang_qbmin, ang_qbmax2, qarear_qmin, qarear_qmin2;

  // get parameters

  iget = ug_get_int_param ("mqchkb", &mqchkb, Param_Struct_Ptr);

  iget = ug_get_double_param ("ang_qbmax", &ang_qbmax, Param_Struct_Ptr);
  iget = ug_get_double_param ("ang_qbmin", &ang_qbmin, Param_Struct_Ptr);
  iget = ug_get_double_param ("ang_qbmax2", &ang_qbmax2, Param_Struct_Ptr);
  iget = ug_get_double_param ("qarear_qmin", &qarear_qmin, Param_Struct_Ptr);
  iget = ug_get_double_param ("qarear_qmin2", &qarear_qmin2, Param_Struct_Ptr);

  if (mqchkb == 0)
    return;

  // check and output boundary surface face angles

  ug3_write_angchkb (nbface, nquad, inibf, iniq,
                     ang_qbmin, ang_qbmax, ang_qbmax2, x);

  // check and output boundary surface face area-length to edge-length ratios

  ug3_write_qarearchk (nbface, nquad, inibf, iniq,
                       qarear_qmin, qarear_qmin2, x);

  return;
}
