#include "UG3_LIB.h"

INT_ ug3_qchk_initialize_param (UG_Param_Struct * Param_Struct_Ptr)
{

/*
 * Set the name, flag, default value, minimum allowable value, maximum allowable
 * value and description for all QCHK parameters.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_qchk_initialize_param.c,v 1.18 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ierr;

  // set int params

  ierr = ug_set_int_param_struct ("mqchk", "",
   "Element quality measure information output flag.",
   "\
If mqchk = 0, then do not generate element quality measure information. ; \
If mqchk = 1, then generate element quality measure information. ; \
If mqchk = 2, then generate element quality measure information including \
element to element neighbor measures. \
   ",
   4, 0, 1, 0, 2, Param_Struct_Ptr);

  if (ierr) return (ierr);

  ierr = ug_set_int_param_struct ("m_volrchk", "",
   "Output volume ratio check flag.",
   "\
If m_volrchk = 0, then do not check volume ratio between elements. ; \
If m_volrchk = 1, then check volume ratio between elements using \
face map data structure. ; \
If m_volrchk = 2, then check volume ratio between elements using \
element neighbor map data structure (only checks tet-elements). \
   ",
   4, 0, 1, 0, 2, Param_Struct_Ptr);

  if (ierr) return (ierr);

  ierr = ug_set_int_param_struct ("m_qvrrchk", "",
   "Quality function Q (based on vol/radius ratio) output flag.",

   "\
If m_qvrrchk = 0, then do not output quality function Q (based on vol/radius ratio). ; \
If m_qvrrchk = 1, then output quality function Q (based on vol/radius ratio). \
   ",
   4, 0, 0, 0, 1, Param_Struct_Ptr);

  if (ierr) return (ierr);

  // set double params

  ierr = ug_set_double_param_struct ("ang_qmax", "",
   "Output dihedral angle check quality limit.",
"\
Typical maximum angle for good quaility elements. \
   ",
   4, 0, 160.0, 0.0, 180.0, Param_Struct_Ptr);

  if (ierr) return (ierr);

  ierr = ug_set_double_param_struct ("ang_qmax2", "",
   "Output dihedral angle check usable limit.",
"\
Typical maximum angle for a usable volume mesh. \
   ",
   4, 0, 179.9, 0.0, 180.0, Param_Struct_Ptr);

  if (ierr) return (ierr);

  ierr = ug_set_double_param_struct ("qvlr_qmin", "",
   "Quality function Q (based on vol/length ratio) quality limit.",
"\
Typical minimum quality function q (based on vol/length ratio) for good quaility elements. \
   ",
   4, 0, 0.1, 0.0, 1.0, Param_Struct_Ptr);

  if (ierr) return (ierr);

  ierr = ug_set_double_param_struct ("qvlr_qmin2", "",
   "Quality function Q (based on vol/length ratio) usable limit.",
"\
Typical minimum quality function q (based on vol/length ratio) for a usable volume mesh. \
   ",
   4, 0, 0.01, 0.0, 1.0, Param_Struct_Ptr);

  if (ierr) return (ierr);

  ierr = ug_set_double_param_struct ("qvrr_qmin", "",
   "Quality function Q (based on vol/radius ratio) quality limit.",
"\
Typical minimum quality function q (based on vol/radius ratio) for good quaility elements. \
   ",
   4, 0, 0.1, 0.0, 1.0, Param_Struct_Ptr);

  if (ierr) return (ierr);

  ierr = ug_set_double_param_struct ("qvrr_qmin2", "",
   "Output quality function Q (based on vol/radius ratio) check usable limit.",
"\
Typical minimum quality function q (based on vol/radius ratio) for a usable volume mesh. \
   ",
   4, 0, 0.01, 0.0, 1.0, Param_Struct_Ptr);

  if (ierr) return (ierr);

  ierr = ug_set_double_param_struct ("volr_qmin", "",
   "Output volume ratio check quality limit.",
"\
Typical minimum volume ratio for good quaility elements. \
   ",
   4, 0, 0.1, 0.0, 1.0, Param_Struct_Ptr);

  if (ierr) return (ierr);

  ierr = ug_set_double_param_struct ("volr_qmin2", "",
   "Output volume ratio check quality limit.",
"\
Typical minimum volume ratio for a usable volume mesh. \
   ",
   4, 0, 0.01, 0.0, 1.0, Param_Struct_Ptr);

  if (ierr) return (ierr);

  ierr = ug_set_double_param_struct ("dx_tol", "",
   "Output relative tolerance for element edge-length checking.",
"\
Relative tolerance used to determine if element edge-length is too small. \
   ",
   4, 0, 1.0e-12, 0.0, 1.0, Param_Struct_Ptr);

  if (ierr) return (ierr);

  ierr = ug_set_double_param_struct ("vol_tol", "",
   "Output relative tolerance for element volume checking.",
"\
Relative tolerance used to determine if element volume is usable. \
   ",
   4, 0, 1.0e-12, 0.0, 1.0, Param_Struct_Ptr);

  if (ierr) return (ierr);

  // set default values

  ug_set_param_def (Param_Struct_Ptr);

  return (0);
}
