#include "UG3_LIB.h"

INT_ ug3_qchk (int argc,
               char *argv[],
               INT_ nbface,
               INT_ nquad,
               INT_ nelem,
               INT_ nelemc5,
               INT_ nelemc6,
               INT_ nelemc8,
               INT_ nnode,
               INT_ nsplit,
               INT_1D * ibcibf,
               INT_3D * inibf,
               INT_4D * iniq,
               INT_4D * iniel,
               INT_5D * inielc5,
               INT_6D * inielc6,
               INT_8D * inielc8,
               INT_1D * ielc8isplit,
               INT_9D * inisplit,
               DOUBLE_3D * x)
{
  // Check and output element quality information.

  UG_Param_Struct * Param_Struct_Ptr;

  INT_ ierr;

  // malloc and set parameter structure arrays

  ierr = ug_set_prog_param (argv, argc, 0, 1, 0, &Param_Struct_Ptr);
  ierr = MAX (ierr, 0);

  // check and output element quality information

  if (ierr == 0)
    ierr = ug3_qchk2 (nbface, nquad, nelem, nelemc5, nelemc6, nelemc8,
                      nnode, nsplit,
                      ibcibf, inibf, iniq,
                      iniel, inielc5, inielc6, inielc8, ielc8isplit, inisplit,
                      x,
                      Param_Struct_Ptr);

  ug_free_param (Param_Struct_Ptr);

  return ierr;
}

INT_ ug3_qchk2 (INT_ nbface,
                INT_ nquad,
                INT_ nelem,
                INT_ nelemc5,
                INT_ nelemc6,
                INT_ nelemc8,
                INT_ nnode,
                INT_ nsplit,
                INT_1D * ibcibf,
                INT_3D * inibf,
                INT_4D * iniq,
                INT_4D * iniel,
                INT_5D * inielc5,
                INT_6D * inielc6,
                INT_8D * inielc8,
                INT_1D * ielc8isplit,
                INT_9D * inisplit,
                DOUBLE_3D * x,
                UG_Param_Struct * Param_Struct_Ptr)
{

/*
 * Check and output element quality information.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_qchk.c,v 1.29 2022/05/25 23:50:10 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_4D *ieliel = NULL;
  INT_6D *initf = NULL;
  INT_7D *iniqf = NULL;
  INT_1D *qlist = NULL;
  INT_1D *qlist5 = NULL;
  INT_1D *qlist6 = NULL;
  INT_1D *qlist8 = NULL;

  DOUBLE_1D *vol = NULL;

  INT_ iget;
  INT_ ierr = 0;
  INT_ mmsg = 1;
  INT_ mqchk = 1;
  INT_ mscale = 1;
  INT_ m_volrchk = 1;
  INT_ m_qvrrchk = 0;
  INT_ ntface = 0;
  INT_ nqface = 0;

  double ang_qmax, ang_qmax2, dx_tol, qvlr_qmin, qvlr_qmin2,
         qvrr_qmin, qvrr_qmin2, vol_tol, volr_qmin, volr_qmin2;

  // get parameters

  iget = ug_get_int_param ("mmsg", &mmsg, Param_Struct_Ptr);
  iget = ug_get_int_param ("mqchk", &mqchk, Param_Struct_Ptr);
  iget = ug_get_int_param ("m_volrchk", &m_volrchk, Param_Struct_Ptr);
  iget = ug_get_int_param ("m_qvrrchk", &m_qvrrchk, Param_Struct_Ptr);

  iget = ug_get_double_param ("ang_qmax", &ang_qmax, Param_Struct_Ptr);
  iget = ug_get_double_param ("ang_qmax2", &ang_qmax2, Param_Struct_Ptr);
  iget = ug_get_double_param ("dx_tol", &dx_tol, Param_Struct_Ptr);
  iget = ug_get_double_param ("qvlr_qmin", &qvlr_qmin, Param_Struct_Ptr);
  iget = ug_get_double_param ("qvlr_qmin2", &qvlr_qmin2, Param_Struct_Ptr);
  iget = ug_get_double_param ("qvrr_qmin", &qvrr_qmin, Param_Struct_Ptr);
  iget = ug_get_double_param ("qvrr_qmin2", &qvrr_qmin2, Param_Struct_Ptr);
  iget = ug_get_double_param ("vol_tol", &vol_tol, Param_Struct_Ptr);
  iget = ug_get_double_param ("volr_qmin", &volr_qmin, Param_Struct_Ptr);
  iget = ug_get_double_param ("volr_qmin2", &volr_qmin2, Param_Struct_Ptr);

  if (mmsg <= 0 || mqchk == 0 || nelem+nelemc5+nelemc6+nelemc8 == 0)
    return (0);

  // check element angles
  // check element edge-lengths
  // check element volume
  // check the volume-length to edge-length ratio function
  // check the volume to circum-radius cubed ratio function

  ug3_qchk_i (mmsg, mscale, m_qvrrchk, nelem, nelemc5, nelemc6, nelemc8, 3,
              iniel, inielc5, inielc6, inielc8,
              qlist, qlist5, qlist6, qlist8,
              ang_qmax, ang_qmax2, dx_tol, qvlr_qmin, qvlr_qmin2,
              qvrr_qmin, qvrr_qmin2, vol_tol,
              x);

  // check element volume ratio (face map method)

  if (mqchk == 2 && m_volrchk == 1)
  {
    // determine face map

    ierr = ug3_face_map (0, nbface, nquad, nelem, nelemc5, nelemc6, nelemc8,
                         nsplit, &ntface, &nqface,
                         ibcibf, inibf, iniq,
                         iniel, inielc5, inielc6, inielc8,
                         ielc8isplit, inisplit,
                         &initf, &iniqf);

    // determine element volume

    if (ierr == 0)
      ug3_volm (nelem, nelemc5, nelemc6, nelemc8,
                iniel, inielc5, inielc6, inielc8,
                &vol, x);

    // check element volume ratio

    if (ierr == 0)
      ug3_write_volrchk (mmsg, nelem, nelemc5, nelemc6, ntface, nqface,
                         initf, iniqf, qlist, qlist5, qlist6, qlist8,
                         volr_qmin, volr_qmin2, vol);
  }

  // check element volume ratio (element neighbor map method - tet only)

  else if (mqchk == 2 && m_volrchk == 2)
  {
    // determine element neighbor map

    ierr = ug3_ieliel2 (nelem, nnode, iniel, &ieliel);

    // determine element volume

    if (ierr == 0)
      ug3_volm (nelem, nelemc5, nelemc6, nelemc8,
                iniel, inielc5, inielc6, inielc8,
                &vol, x);

    // check element volume ratio

    if (ierr == 0)
      ug3_write_volrchk2 (mmsg, nelem, ieliel, qlist, volr_qmin, volr_qmin2, vol);
  }

  // free temporary arrays

  ug_free (ieliel);
  ug_free (vol);
  ug_free (initf);
  ug_free (iniqf);
  ug_free (qlist);
  ug_free (qlist5);
  ug_free (qlist6);
  ug_free (qlist8);

  if (mmsg) {
    ug_message ("");
    ug_cpu_message ("UG3      :");
  }

  return (0);
}

void ug3_qchk_i (INT_ mmsg,
                 INT_ mscale,
                 INT_ m_qvrrchk,
                 INT_ nelem,
                 INT_ nelemc5,
                 INT_ nelemc6,
                 INT_ nelemc8,
                 INT_ task,
                 INT_4D * iniel,
                 INT_5D * inielc5,
                 INT_6D * inielc6,
                 INT_8D * inielc8,
                 INT_1D * qlist,
                 INT_1D * qlist5,
                 INT_1D * qlist6,
                 INT_1D * qlist8,
                 double ang_qmax,
                 double ang_qmax2,
                 double dx_tol,
                 double qvlr_qmin,
                 double qvlr_qmin2,
                 double qvrr_qmin,
                 double qvrr_qmin2,
                 double vol_tol,
                 DOUBLE_3D * x)
{

/*
 * Check and output element quality information.
 * Exclude information for element to element neighbors.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_qchk.c,v 1.29 2022/05/25 23:50:10 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  // check element angles

  ug3_write_angchk (mmsg, nelem, nelemc5, nelemc6, nelemc8, task,
                    iniel, inielc5, inielc6, inielc8,
                    qlist, qlist5, qlist6, qlist8,
                    ang_qmax, ang_qmax2, x);

  // check element edge-lengths

  ug3_write_dxchk (mmsg, nelem, nelemc5, nelemc6, nelemc8, task,
                   iniel, inielc5, inielc6, inielc8,
                   qlist, qlist5, qlist6, qlist8,
                   dx_tol, x);

  // check element volume

  ug3_write_volchk (mmsg, nelem, nelemc5, nelemc6, nelemc8, task,
                    iniel, inielc5, inielc6, inielc8,
                    qlist, qlist5, qlist6, qlist8,
                    vol_tol, x);

  // check the volume-length to edge-length ratio function

  ug3_write_qvlrchk (mmsg, mscale, nelem, nelemc5, nelemc6, nelemc8, task,
                     iniel, inielc5, inielc6, inielc8,
                     qlist, qlist5, qlist6, qlist8,
                     qvlr_qmin, qvlr_qmin2, x);

  // check the volume to circum-radius cubed function, q.

  if (m_qvrrchk)
    ug3_write_qvrrchk (mmsg, nelem, nelemc5, nelemc6, nelemc8, task,
                       iniel, inielc5, inielc6, inielc8,
                       qlist, qlist5, qlist6, qlist8,
                       qvrr_qmin, qvrr_qmin2, x);

  return;
}
