#include "UG3_LIB.h"

/*
 * Determine face quality measure functions.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_qarear.c,v 1.6 2022/08/22 20:02:56 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

double ug3_qarear (double x11,
                   double x12,
                   double x13,
                   double x21,
                   double x22,
                   double x23,
                   double x31,
                   double x32,
                   double x33)
{

  // Determine the tria area-length to edge-length ratio function, q.

  double a1, a2, a3, 
         area, cq,
         dx211, dx212, dx213,
         dx311, dx312, dx313,
         dx321, dx322, dx323,
         lsum, q;

  cq = 2.0 * sqrt (3.0);

  dx211 = x21 - x11;
  dx212 = x22 - x12;
  dx213 = x23 - x13;
  dx311 = x31 - x11;
  dx312 = x32 - x12;
  dx313 = x33 - x13;
  dx321 = x31 - x21;
  dx322 = x32 - x22;
  dx323 = x33 - x23;

  lsum = dx211 * dx211 + dx212 * dx212 + dx213 * dx213
       + dx321 * dx321 + dx322 * dx322 + dx323 * dx323
       + dx311 * dx311 + dx312 * dx312 + dx313 * dx313;

  a1 = dx212 * dx313 - dx213 * dx312;
  a2 = dx213 * dx311 - dx211 * dx313;
  a3 = dx211 * dx312 - dx212 * dx311;

  area = sqrt (a1 * a1 + a2 * a2 + a3 * a3);

  q = cq * area / lsum;

  return (q);
}

double ug3_tria_qarear (INT_ inode1,
                        INT_ inode2,
                        INT_ inode3,
                        DOUBLE_3D * x)
{
  // Determine the tria area-length to edge-length ratio function, q.

  return (ug3_qarear (x[inode1][0], x[inode1][1], x[inode1][2], 
                      x[inode2][0], x[inode2][1], x[inode2][2], 
                      x[inode3][0], x[inode3][1], x[inode3][2]));
}

double ug3_quad_qarear (INT_ inode1,
                        INT_ inode2,
                        INT_ inode3,
                        INT_ inode4,
                        DOUBLE_3D * x)
{

  // Determine the quad area-length to edge-length ratio function, q.

  double a11, a12, a13, 
         a21, a22, a23,
         area, cq,
         dx211, dx212, dx213,
         dx321, dx322, dx323,
         dx431, dx432, dx433,
         dx411, dx412, dx413,
         lsum, q,
         x11, x12, x13,
         x21, x22, x23,
         x31, x32, x33,
         x41, x42, x43;

  cq = 2.0;

  x11 = x[inode1][0];
  x12 = x[inode1][1];
  x13 = x[inode1][2];
  x21 = x[inode2][0];
  x22 = x[inode2][1];
  x23 = x[inode2][2];
  x31 = x[inode3][0];
  x32 = x[inode3][1];
  x33 = x[inode3][2];
  x41 = x[inode4][0];
  x42 = x[inode4][1];
  x43 = x[inode4][2];

  dx211 = x21 - x11;
  dx212 = x22 - x12;
  dx213 = x23 - x13;
  dx321 = x31 - x21;
  dx322 = x32 - x22;
  dx323 = x33 - x23;
  dx431 = x41 - x31;
  dx432 = x42 - x32;
  dx433 = x43 - x33;
  dx411 = x41 - x11;
  dx412 = x42 - x12;
  dx413 = x43 - x13;

  lsum = dx211 * dx211 + dx212 * dx212 + dx213 * dx213
       + dx321 * dx321 + dx322 * dx322 + dx323 * dx323
       + dx431 * dx431 + dx432 * dx432 + dx433 * dx433
       + dx411 * dx411 + dx412 * dx412 + dx413 * dx413;

  a11 = dx212 * dx413 - dx213 * dx412;
  a12 = dx213 * dx411 - dx211 * dx413;
  a13 = dx211 * dx412 - dx212 * dx411;
  a21 = dx322 * dx433 - dx323 * dx432;
  a22 = dx323 * dx431 - dx321 * dx433;
  a23 = dx321 * dx432 - dx322 * dx431;

  area = sqrt (a11 * a11 + a12 * a12 + a13 * a13)
       + sqrt (a21 * a21 + a22 * a22 + a23 * a23);

  q = cq * area / lsum;

  return (q);
}
