#include "UG3_LIB.h"

void ug3_nnodeb
 (INT_ nbface,
  INT_ nquad,
  INT_ *nnodeb,
  INT_3D * inibf,
  INT_4D * iniq)

{

/*
 * Determine the maximum node index on the boundary surface.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_nnodeb.c,v 1.12 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ibface, iquad, inode1, inode2, inode3, inode4;

  *nnodeb = 0;

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    inode1 = inibf[ibface][0];
    inode2 = inibf[ibface][1];
    inode3 = inibf[ibface][2];

    *nnodeb = MAX (inode1, *nnodeb);
    *nnodeb = MAX (inode2, *nnodeb);
    *nnodeb = MAX (inode3, *nnodeb);
  }

  for (iquad = 1; iquad <= nquad; ++iquad)
  {
    inode1 = iniq[iquad][0];
    inode2 = iniq[iquad][1];
    inode3 = iniq[iquad][2];
    inode4 = iniq[iquad][3];

    *nnodeb = MAX (inode1, *nnodeb);
    *nnodeb = MAX (inode2, *nnodeb);
    *nnodeb = MAX (inode3, *nnodeb);
    *nnodeb = MAX (inode4, *nnodeb);
  }

  return;

}

void ug3_p2_nnodeb
 (INT_ nbface,
  INT_ nquad,
  INT_ *nnodeb,
  INT_ p_order,
  INT_3D * inibf,
  INT_4D * iniq,
  INT_3D * p2_inibf,
  INT_5D * p2_iniq)

{

/*
 * Determine the maximum node index on the boundary surface.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_nnodeb.c,v 1.12 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ibface, iquad, inode1, inode2, inode3, inode4, inode5;

  *nnodeb = 0;

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    inode1 = inibf[ibface][0];
    inode2 = inibf[ibface][1];
    inode3 = inibf[ibface][2];

    *nnodeb = MAX (inode1, *nnodeb);
    *nnodeb = MAX (inode2, *nnodeb);
    *nnodeb = MAX (inode3, *nnodeb);
  }

  for (iquad = 1; iquad <= nquad; ++iquad)
  {
    inode1 = iniq[iquad][0];
    inode2 = iniq[iquad][1];
    inode3 = iniq[iquad][2];
    inode4 = iniq[iquad][3];

    *nnodeb = MAX (inode1, *nnodeb);
    *nnodeb = MAX (inode2, *nnodeb);
    *nnodeb = MAX (inode3, *nnodeb);
    *nnodeb = MAX (inode4, *nnodeb);
  }

  if (p_order == 2)
  {
    for (ibface = 1; ibface <= nbface; ++ibface)
    {
      inode1 = p2_inibf[ibface][0];
      inode2 = p2_inibf[ibface][1];
      inode3 = p2_inibf[ibface][2];

      *nnodeb = MAX (inode1, *nnodeb);
      *nnodeb = MAX (inode2, *nnodeb);
      *nnodeb = MAX (inode3, *nnodeb);
    }

    for (iquad = 1; iquad <= nquad; ++iquad)
    {
      inode1 = p2_iniq[iquad][0];
      inode2 = p2_iniq[iquad][1];
      inode3 = p2_iniq[iquad][2];
      inode4 = p2_iniq[iquad][3];
      inode5 = p2_iniq[iquad][4];

      *nnodeb = MAX (inode1, *nnodeb);
      *nnodeb = MAX (inode2, *nnodeb);
      *nnodeb = MAX (inode3, *nnodeb);
      *nnodeb = MAX (inode4, *nnodeb);
      *nnodeb = MAX (inode5, *nnodeb);
    }
  }

  return;

}
