#include "UG3_LIB.h"

INT_ ug3_nelem_est (INT_ mmsg,
                    INT_ nelem,
                    INT_4D * iniel,
                    DOUBLE_1D * df,
                    DOUBLE_3D * x)
{

/*
 * Estimate the total number of elements that will be generated.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_UG_MAX Text;

  INT_ ielem, inode1, inode2, inode3, inode4, nelem_est;

  double dc0, dc1d4, df0, est_i, vol;

  dc0 = 0.0;
  dc1d4 = 0.25;

  est_i = dc0;

  for (ielem = 1; ielem <= nelem; ++ielem)
  {
    inode1 = iniel[ielem][0];
    inode2 = iniel[ielem][1];
    inode3 = iniel[ielem][2];
    inode4 = iniel[ielem][3];

    vol = ug3_tet_vol (inode1, inode2, inode3, inode4, x);

    df0 = dc1d4 * (df[inode1] + df[inode2] + df[inode3] + df[inode4]);

    est_i = est_i + vol / (df0 * df0 * df0);
  }

  nelem_est = NINT (est_i);

  if (mmsg == 2)
  {
    snprintf (Text, sizeof(Text), "Maximum Estimate   : Elements          =%10i", (int) nelem_est);
    ug_message (Text);
  }

  return (nelem_est);
}
