#include "UG3_LIB.h"

void ug3_met2df
 (INT_ nnode,
  DOUBLE_6D * met,
  DOUBLE_1D * df)

{

/*
 * Determine the equivalent isotropic length scale from a given metric.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_met2df.c,v 1.3 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ inode;

  double dc1, dc6, dc1d6;

  dc1 = 1.0;
  dc6 = 6.0;

  dc1d6 = dc1 / dc6;

  for (inode = 1; inode <= nnode; ++inode)
  {
    df[inode] = pow (met[inode][0] * (met[inode][3]*met[inode][5] - met[inode][4]*met[inode][4])
                   - met[inode][1] * (met[inode][1]*met[inode][5] - met[inode][2]*met[inode][4])
                   + met[inode][2] * (met[inode][1]*met[inode][4] - met[inode][2]*met[inode][3]),
                   - dc1d6);
  }

  return;
}
