#include "UG3_LIB.h"

/*
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_merge_mesh.c,v 1.3 2023/07/12 19:16:30 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

INT_ ug3_merge_mesh (
  INT_ final_mesh,
  INT_ *nbedge,
  INT_ *nbface,
  INT_ *nquad,
  INT_ *nblelem,
  INT_ *nelem,
  INT_ *nelemc5,
  INT_ *nelemc6,
  INT_ *nelemc8,
  INT_ *nnode,
  INT_ vol_id,
  INT_1D **idibe,
  INT_2D **inibe,
  INT_1D **ibcibf,
  INT_1D **idibf,
  INT_1D **irfibf,
  INT_3D **inibf,
  INT_4D **iniq,
  INT_1D **idiel,
  INT_4D **iniel,
  INT_5D **inielc5,
  INT_6D **inielc6,
  INT_8D **inielc8,
  DOUBLE_3D **x,
  DOUBLE_1D **ds,
  DOUBLE_1D **del,
  INT_ *nbedge_c,
  INT_ *nbface_c,
  INT_ *nquad_c,
  INT_ *nblelem_c,
  INT_ *nelem_c,
  INT_ *nelemc5_c,
  INT_ *nelemc6_c,
  INT_ *nelemc8_c,
  INT_ *nnode_c,
  INT_1D **idibe_c,
  INT_2D **inibe_c,
  INT_1D **ibcibf_c,
  INT_1D **idibf_c,
  INT_1D **irfibf_c,
  INT_3D **inibf_c,
  INT_4D **iniq_c,
  INT_1D **idiel_c,
  INT_4D **iniel_c,
  INT_5D **inielc5_c,
  INT_6D **inielc6_c,
  INT_8D **inielc8_c,
  DOUBLE_3D **x_c,
  DOUBLE_1D **ds_c,
  DOUBLE_1D **del_c)
{
  // If the data labeled _c is not set then copy volume mesh data.
  // If the data labeled _c is set then merge volume mesh data.
  // If *nnode_c is 0 then the data labeled _c is assumed to not be set.

  INT_ i, j;
  INT_ ierr = 0;
  INT_ nbedge_ci = 0;
  INT_ nbface_ci = 0;
  INT_ nquad_ci = 0;
  INT_ nblelem_ci = 0;
  INT_ nelem_ci = 0;
  INT_ nelemc5_ci = 0;
  INT_ nelemc6_ci = 0;
  INT_ nelemc8_ci = 0;
  INT_ nnode_ci = 0;
  INT_ nnodeb = 0;

  if (*nnode_c == 0) {

    *idibe_c = NULL;
    *inibe_c = NULL;
    *ibcibf_c = NULL;
    *idibf_c = NULL;
    *irfibf_c = NULL;
    *inibf_c = NULL;
    *iniq_c = NULL;
    *idiel_c = NULL;
    *iniel_c = NULL;
    *inielc5_c = NULL;
    *inielc6_c = NULL;
    *inielc8_c = NULL;
    *x_c = NULL;
    *ds_c = NULL;
    *del_c = NULL;

    *nbedge_c = 0;
    *nbface_c = 0;
    *nquad_c = 0;
    *nblelem_c = 0;
    *nelem_c = 0;
    *nelemc5_c = 0;
    *nelemc6_c = 0;
    *nelemc8_c = 0;
    *nnode_c = 0;
  }
  
  nbedge_ci = (*nbedge) + (*nbedge_c);
  nbface_ci = (*nbface) + (*nbface_c);
  nquad_ci = (*nquad) + (*nquad_c);
  nblelem_ci = (*nblelem) + (*nblelem_c);
  nelem_ci = (*nelem) + (*nelem_c);
  nelemc5_ci = (*nelemc5) + (*nelemc5_c);
  nelemc6_ci = (*nelemc6) + (*nelemc6_c);
  nelemc8_ci = (*nelemc8) + (*nelemc8_c);
  nnode_ci = (*nnode) + (*nnode_c);

  if (*idibe) {

    *idibe_c = (INT_1D *) ug_realloc (&ierr, *idibe_c, (nbedge_ci+1) * sizeof (INT_1D));

    if (ierr) goto mem_error;

    for (i = 1; i <= *nbedge; i++)
      (*idibe_c)[i+(*nbedge_c)] = (*idibe)[i];
  }

  if (*inibe) {

    *inibe_c = (INT_2D *) ug_realloc (&ierr, *inibe_c, (nbedge_ci+1) * sizeof (INT_2D));

    if (ierr) goto mem_error;

    for (i = 1; i <= *nbedge; i++) {
      for (j = 0; j < 2; j++)
        (*inibe_c)[i+(*nbedge_c)][j] = (*inibe)[i][j] + (*nnode_c);
    }
  }

  if (*ibcibf) {

    *ibcibf_c = (INT_1D *) ug_realloc (&ierr, *ibcibf_c, (nbface_ci+nquad_ci+1) * sizeof (INT_1D));

    if (ierr) goto mem_error;

    for (i = 1; i <= (*nbface)+(*nquad); i++)
      (*ibcibf_c)[i+(*nbface_c)+(*nquad_c)] = (*ibcibf)[i];
  }

  if (*idibf) {

    *idibf_c = (INT_1D *) ug_realloc (&ierr, *idibf_c, (nbface_ci+nquad_ci+1) * sizeof (INT_1D));

    if (ierr) goto mem_error;

    for (i = 1; i <= (*nbface)+(*nquad); i++)
      (*idibf_c)[i+(*nbface_c)+(*nquad_c)] = (*idibf)[i];
  }

  if (*irfibf) {

    *irfibf_c = (INT_1D *) ug_realloc (&ierr, *irfibf_c, (nbface_ci+nquad_ci+1) * sizeof (INT_1D));

    if (ierr) goto mem_error;

    for (i = 1; i <= (*nbface)+(*nquad); i++)
      (*irfibf_c)[i+(*nbface_c)+(*nquad_c)] = (*irfibf)[i];
  }

  if (*inibf) {

    *inibf_c = (INT_3D *) ug_realloc (&ierr, *inibf_c, (nbface_ci+1) * sizeof (INT_3D));

    if (ierr) goto mem_error;

    for (i = 1; i <= *nbface; i++) {
      for (j = 0; j < 3; j++)
        (*inibf_c)[i+(*nbface_c)][j] = (*inibf)[i][j] + (*nnode_c);
    }
  }

  if (*iniq) {

    *iniq_c = (INT_4D *) ug_realloc (&ierr, *iniq_c, (nquad_ci+1) * sizeof (INT_4D));

    if (ierr) goto mem_error;

    for (i = 1; i <= *nquad; i++) {
      for (j = 0; j < 4; j++)
        (*iniq_c)[i+(*nquad_c)][j] = (*iniq)[i][j] + (*nnode_c);
    }
  }


  if (vol_id >= 0 || *idiel) {

    *idiel_c = (INT_1D *) ug_realloc (&ierr, *idiel_c, (nelem_ci+nelemc5_ci+nelemc6_ci+nelemc8_ci+1) * sizeof (INT_1D));

    if (ierr) goto mem_error;
  }

  if (*idiel) {

    for (i = 1; i <= (*nelem)+(*nelemc5)+(*nelemc6)+(*nelemc8); i++)
      (*idiel_c)[i+(*nelem_c)+(*nelemc5_c)+(*nelemc6_c)+(*nelemc8_c)] = (*idiel)[i];
  }
  else {

    for (i = 1; i <= (*nelem)+(*nelemc5)+(*nelemc6)+(*nelemc8); i++)
      (*idiel_c)[i+(*nelem_c)+(*nelemc5_c)+(*nelemc6_c)+(*nelemc8_c)] = vol_id;
  }

  if (*iniel) {

    *iniel_c = (INT_4D *) ug_realloc (&ierr, *iniel_c, (nelem_ci+1) * sizeof (INT_4D));

    if (ierr) goto mem_error;

    for (i = 1; i <= *nelem; i++) {
      for (j = 0; j < 4; j++)
        (*iniel_c)[i+(*nelem_c)][j] = (*iniel)[i][j] + (*nnode_c);
    }
  }

  if (*inielc5) {

    *inielc5_c = (INT_5D *) ug_realloc (&ierr, *inielc5_c, (nelemc5_ci+1) * sizeof (INT_5D));

    if (ierr) goto mem_error;

    for (i = 1; i <= *nelemc5; i++) {
      for (j = 0; j < 5; j++)
        (*inielc5_c)[i+(*nelemc5_c)][j] = (*inielc5)[i][j] + (*nnode_c);
    }
  }

  if (*inielc6) {

    *inielc6_c = (INT_6D *) ug_realloc (&ierr, *inielc6_c, (nelemc6_ci+1) * sizeof (INT_6D));

    if (ierr) goto mem_error;

    for (i = 1; i <= *nelemc6; i++) {
      for (j = 0; j < 6; j++)
        (*inielc6_c)[i+(*nelemc6_c)][j] = (*inielc6)[i][j] + (*nnode_c);
    }
  }

  if (*inielc8) {

    *inielc8_c = (INT_8D *) ug_realloc (&ierr, *inielc8_c, (nelemc8_ci+1) * sizeof (INT_8D));

    if (ierr) goto mem_error;

    for (i = 1; i <= *nelemc8; i++) {
      for (j = 0; j < 8; j++)
        (*inielc8_c)[i+(*nelemc8_c)][j] = (*inielc8)[i][j] + (*nnode_c);
    }
  }

  if (*x) {

    *x_c = (DOUBLE_3D *) ug_realloc (&ierr, *x_c, (nnode_ci+1) * sizeof (DOUBLE_3D));

    if (ierr) goto mem_error;

    for (i = 1; i <= *nnode; i++) {
      for (j = 0; j < 3; j++)
        (*x_c)[i+(*nnode_c)][j] = (*x)[i][j];
    }
  }

  if (*ds) {

    *ds_c = (DOUBLE_1D *) ug_realloc (&ierr, *ds_c, (nnode_ci+1) * sizeof (DOUBLE_1D));

    if (ierr) goto mem_error;

    for (i = 1; i <= *nnode; i++)
      (*ds_c)[i+(*nnode_c)] = (*ds)[i];
  }

  if (*del) {

    *del_c = (DOUBLE_1D *) ug_realloc (&ierr, *del_c, (nnode_ci+1) * sizeof (DOUBLE_1D));

    if (ierr) goto mem_error;

    for (i = 1; i <= *nnode; i++)
      (*del_c)[i+(*nnode_c)] = (*del)[i];
  }

  *nbedge_c = nbedge_ci;
  *nbface_c = nbface_ci;
  *nquad_c = nquad_ci;
  *nblelem_c = nblelem_ci;
  *nelem_c = nelem_ci;
  *nelemc5_c = nelemc5_ci;
  *nelemc6_c = nelemc6_ci;
  *nelemc8_c = nelemc8_ci;
  *nnode_c = nnode_ci;

  ug_free (*ibcibf);
  ug_free (*idibe);
  ug_free (*idibf);
  ug_free (*inibe);
  ug_free (*inibf);
  ug_free (*iniq);
  ug_free (*irfibf);
  ug_free (*idiel);
  ug_free (*iniel);
  ug_free (*inielc5);
  ug_free (*inielc6);
  ug_free (*inielc8);

  ug_free (*x);
  ug_free (*ds);
  ug_free (*del);

  *ibcibf = NULL;
  *idibe = NULL;
  *idibf = NULL;
  *inibe = NULL;
  *inibf = NULL;
  *iniq = NULL;
  *irfibf = NULL;
  *idiel = NULL;
  *iniel = NULL;
  *inielc5 = NULL;
  *inielc6 = NULL;
  *inielc8 = NULL;

  *x = NULL;
  *ds = NULL;
  *del = NULL;

  *nbedge = 0;
  *nbface = 0;
  *nquad = 0;
  *nblelem = 0;
  *nelem = 0;
  *nelemc5 = 0;
  *nelemc6 = 0;
  *nelemc8 = 0;
  *nnode = 0;

  if (final_mesh) {

    *ibcibf = *ibcibf_c;
    *idibe = *idibe_c;
    *idibf = *idibf_c;
    *inibe = *inibe_c;
    *inibf = *inibf_c;
    *iniq = *iniq_c;
    *irfibf = *irfibf_c;
    *idiel = *idiel_c;
    *iniel = *iniel_c;
    *inielc5 = *inielc5_c;
    *inielc6 = *inielc6_c;
    *inielc8 = *inielc8_c;

    *x = *x_c;
    *ds = *ds_c;
    *del = *del_c;

    *nbedge = *nbedge_c;
    *nbface = *nbface_c;
    *nquad = *nquad_c;
    *nblelem = *nblelem_c;
    *nelem = *nelem_c;
    *nelemc5 = *nelemc5_c;
    *nelemc6 = *nelemc6_c;
    *nelemc8 = *nelemc8_c;
    *nnode = *nnode_c;

    *ibcibf_c = NULL;
    *idibe_c = NULL;
    *idibf_c = NULL;
    *inibe_c = NULL;
    *inibf_c = NULL;
    *iniq_c = NULL;
    *irfibf_c = NULL;
    *idiel_c = NULL;
    *iniel_c = NULL;
    *inielc5_c = NULL;
    *inielc6_c = NULL;
    *inielc8_c = NULL;

    *x_c = NULL;
    *ds_c = NULL;
    *del_c = NULL;

    *nbedge_c = 0;
    *nbface_c = 0;
    *nquad_c = 0;
    *nblelem_c = 0;
    *nelem_c = 0;
    *nelemc5_c = 0;
    *nelemc6_c = 0;
    *nelemc8_c = 0;
    *nnode_c = 0;

    ierr = ug3_reorderb2 (*nbedge, *nbface, *nelem, *nelemc5, *nelemc6, *nelemc8,
                          *nnode, &nnodeb, *nquad, 
                          *inibe, *inibf, *iniel, *inielc5, *inielc6, *inielc8,
                          *iniq,
                          *del, NULL, *ds, NULL, NULL, NULL, *x);

    if (ierr) return ierr;
  }

  mem_error:

  if (ierr) {
    ug_error_message ("*** ERROR 100361 : unable to allocate required memory ***");
    return 100361;
  }

  return 0;
}
