#include "UG3_LIB.h"

INT_ ug3_iqin
 (INT_ nquad,
  INT_ *nqpntd,
  INT_ nnode,
  INT_ *nqpnt,
  INT_4D * iniq,
  INT_1D ** iqin,
  INT_1D * liqin)

{

/*
 * Create a list of quad faces surrounding a node.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_iqin.c,v 1.5 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ierr, inode, inode1, inode2, inode3, inode4, iquad, loc, nqpn;

  for (inode = 1; inode <= nnode; ++inode)
  {
    liqin[inode] = 0;
  }

  for (iquad = 1; iquad <= nquad; ++iquad)
  {
    inode1 = iniq[iquad][0];
    inode2 = iniq[iquad][1];
    inode3 = iniq[iquad][2];
    inode4 = iniq[iquad][3];

    ++(liqin[inode1]);
    ++(liqin[inode2]);
    ++(liqin[inode3]);
    ++(liqin[inode4]);
  }

  *nqpnt = 0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    *nqpnt = *nqpnt + liqin[inode];
  }

  if (*nqpnt > *nqpntd)
  {
    *nqpntd = *nqpnt;

    ierr = 0;

    *iqin = (INT_1D *) ug_realloc (&ierr, *iqin, (*nqpntd+1) * sizeof (INT_1D));
                                       

    if (ierr > 0)
    {
      ug_error_message ("*** ERROR 100323 : unable to allocase required memory ***");
      return (100323);
    }

  }

  loc = 1;

  nqpn = 0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    loc = loc + nqpn;

    nqpn = liqin[inode];

    liqin[inode] = loc;
  }

  for (iquad = 1; iquad <= nquad; ++iquad)
  {
    inode1 = iniq[iquad][0];
    inode2 = iniq[iquad][1];
    inode3 = iniq[iquad][2];
    inode4 = iniq[iquad][3];

    loc = liqin[inode1];

    (*iqin)[loc] = iquad;

    ++loc;

    liqin[inode1] = loc;

    loc = liqin[inode2];

    (*iqin)[loc] = iquad;

    ++loc;

    liqin[inode2] = loc;

    loc = liqin[inode3];

    (*iqin)[loc] = iquad;

    ++loc;

    liqin[inode3] = loc;

    loc = liqin[inode4];

    (*iqin)[loc] = iquad;

    ++loc;

    liqin[inode4] = loc;
  }

  for (inode = nnode + 1; inode >= 2; --inode)
  {
    liqin[inode] = liqin[inode - 1];
  }

  liqin[1] = 1;

  return (0);

}
