#include "UG3_LIB.h"

/*
 * UG3 LIB : Unxtructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_inibe.c,v 1.1 2023/06/16 16:30:55 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

INT_ ug3_inibe (
  INT_ mmsg,
  INT_ *nbedge,
  INT_ nbface,
  INT_ nnode,
  INT_1D *ibcibf,
  INT_1D **ibfibe,
  INT_3D **ibfibf,
  INT_1D **ibfin,
  INT_2D **inibe,
  INT_3D *inibf,
  INT_1D **libfin)
{
  // Get number of boundary edges, connectivity, and edge face map.

  INT_1D *ibfichk = NULL;
  INT_1D *mchkbf = NULL;

  INT_ ibedge1, ibedge2, ibedge3, ibface, nbfpnt;
  INT_ ierr = 0;
  INT_ merr = 0;
  INT_ mmultc = 0;
  INT_ mreorder = 0;
  INT_ nbfpntd = 0;

  *nbedge = 0;

  *ibfibe = NULL;
  *ibfibf = NULL;
  *ibfin = NULL;
  *inibe = NULL;
  *libfin = NULL;

  *ibfibf = (INT_3D *) ug_malloc (&ierr, (nbface+1) * sizeof (INT_3D));
  ibfichk = (INT_1D *) ug_malloc (&ierr, (nbface+1) * sizeof (INT_1D));
  *libfin = (INT_1D *) ug_malloc (&ierr, (nnode+2) * sizeof (INT_1D));
  mchkbf = (INT_1D *) ug_malloc (&ierr, (nbface+1) * sizeof (INT_1D));

  if (ierr) {
    ug_error_message ("*** ERROR 100359 : unable to allocate required memory ***");
    ierr = 100359;
    goto cleanup;
  }

  ierr = ug3_ibfin (nbface, &nbfpntd, nnode, &nbfpnt, inibf, ibfin, *libfin);

  if (ierr) goto cleanup;

  ierr = ug3_ibfibf (merr, mmsg, mmultc, mreorder, nbface,
                     ibcibf, *ibfin, inibf, NULL, NULL, *libfin,
                     ibfichk, mchkbf, *ibfibf, NULL, NULL);

  if (ierr) goto cleanup;

  *nbedge = 0;

  ug2_inibe (nbface, nbedge, *ibfibf, inibf, *inibe);

  *ibfibe = (INT_1D *) ug_malloc (&ierr, ((*nbedge)+1) * sizeof (INT_1D));
  *inibe = (INT_2D *) ug_malloc (&ierr, ((*nbedge)+1) * sizeof (INT_2D));

  if (ierr) {
    ug_error_message ("*** ERROR 100360 : unable to allocate required memory ***");
    ierr = 100360;
    goto cleanup;
  }

  ug2_inibe (nbface, nbedge, *ibfibf, inibf, *inibe);

  for (ibface = 1; ibface <= nbface; ibface++) {

    ibedge1 = -(*ibfibf)[ibface][0];
    ibedge2 = -(*ibfibf)[ibface][1];
    ibedge3 = -(*ibfibf)[ibface][2];

    if (ibedge1 > 0) (*ibfibe)[ibedge1] = ibface;
    if (ibedge2 > 0) (*ibfibe)[ibedge2] = ibface;
    if (ibedge3 > 0) (*ibfibe)[ibedge3] = ibface;
  }

  cleanup:

  ug_free (ibfichk);
  ug_free (mchkbf);

  return ierr;
}
