#include "UG3_LIB.h"

INT_ ug3_ifin
 (INT_ nbface,
  INT_ nquad,
  INT_ nnode,
  INT_3D * inibf,
  INT_4D * iniq,
  INT_1D ** ifin,
  INT_1D ** lifin)

{

/*
 * Create a list of tria and quad boundary faces surrounding a node.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_ifin.c,v 1.3 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ibface, inode, inode1, inode2, inode3, inode4, iquad, loc, nfpn, nfpnt;
  INT_ ierr = 0;

  *lifin = (INT_1D *) ug_malloc (&ierr, (nnode+2) * sizeof (INT_1D));

  if (ierr)
  {
    ug_error_message ("*** ERROR 100302 : unable to allocase required memory ***");
    return (100302);
  }
 
  for (inode = 1; inode <= nnode; ++inode)
  {
    (*lifin)[inode] = 0;
  }

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    inode1 = inibf[ibface][0];
    inode2 = inibf[ibface][1];
    inode3 = inibf[ibface][2];

    ++((*lifin)[inode1]);
    ++((*lifin)[inode2]);
    ++((*lifin)[inode3]);
  }

  for (iquad = 1; iquad <= nquad; ++iquad)
  {
    inode1 = iniq[iquad][0];
    inode2 = iniq[iquad][1];
    inode3 = iniq[iquad][2];
    inode4 = iniq[iquad][3];

    ++((*lifin)[inode1]);
    ++((*lifin)[inode2]);
    ++((*lifin)[inode3]);
    ++((*lifin)[inode4]);
  }

  nfpnt = 0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    nfpnt = nfpnt + (*lifin)[inode];
  }

  *ifin = (INT_1D *) ug_malloc (&ierr, (nfpnt+1) * sizeof (INT_1D));

  if (ierr)
  {
    ug_error_message ("*** ERROR 100302 : unable to allocase required memory ***");
    return (100302);
  }

  loc = 1;

  nfpn = 0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    loc = loc + nfpn;

    nfpn = (*lifin)[inode];

    (*lifin)[inode] = loc;
  }

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    inode1 = inibf[ibface][0];
    inode2 = inibf[ibface][1];
    inode3 = inibf[ibface][2];

    loc = (*lifin)[inode1];

    (*ifin)[loc] = ibface;

    ++loc;

    (*lifin)[inode1] = loc;

    loc = (*lifin)[inode2];

    (*ifin)[loc] = ibface;

    ++loc;

    (*lifin)[inode2] = loc;

    loc = (*lifin)[inode3];

    (*ifin)[loc] = ibface;

    ++loc;

    (*lifin)[inode3] = loc;
  }

  for (iquad = 1; iquad <= nquad; ++iquad)
  {
    inode1 = iniq[iquad][0];
    inode2 = iniq[iquad][1];
    inode3 = iniq[iquad][2];
    inode4 = iniq[iquad][3];

    loc = (*lifin)[inode1];

    (*ifin)[loc] = nbface+iquad;

    ++loc;

    (*lifin)[inode1] = loc;

    loc = (*lifin)[inode2];

    (*ifin)[loc] = nbface+iquad;

    ++loc;

    (*lifin)[inode2] = loc;

    loc = (*lifin)[inode3];

    (*ifin)[loc] = nbface+iquad;

    ++loc;

    (*lifin)[inode3] = loc;

    loc = (*lifin)[inode4];

    (*ifin)[loc] = nbface+iquad;

    ++loc;

    (*lifin)[inode4] = loc;
  }

  for (inode = nnode+1; inode >= 2; --inode)
  {
    (*lifin)[inode] = (*lifin)[inode-1];
  }

  (*lifin)[1] = 1;

  return (0);

}
