#include "UG3_LIB.h"

INT_ ug3_ibor
 (INT_ mclosed,
  INT_ merr,
  INT_ mmsg,
  INT_ mopen,
  INT_ nbface,
  INT_ nbo,
  INT_1D * ibcibf,
  INT_3D * ibfibf,
  INT_1D * iboibf,
  INT_1D * ierribf,
  INT_3D * inibf,
  INT_1D * irfibf,
  DOUBLE_3D * x)

{

/*
 * Re-order the boundary surface grid connectivity if any boundary object does
 * not have RH orientation. 
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_ibor.c,v 1.54 2022/11/21 00:25:14 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_133 Text;

  DOUBLE_3D bv, xmnmx[2];

  INT_ ibc, ibface, ibface1, ibface2, ibface3, ibfn, ibo, idir, ierr, ifn,
       imnmx, inode, inode2, inode3, irf0, irf1, irf2, irf3,
       jbface, jbo, jnode, mbvls, mext, mtransp;

  double dc0, xm;

  dc0 = 0.0;

  if (mclosed == 0 || iboibf == NULL)
    return (0);

  ibc = STD_UG3_GBC;

  inode = 1;

  xmnmx[0][0] = x[inode][0];
  xmnmx[1][0] = x[inode][0];
  xmnmx[0][1] = x[inode][1];
  xmnmx[1][1] = x[inode][1];
  xmnmx[0][2] = x[inode][2];
  xmnmx[1][2] = x[inode][2];

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    if (ibcibf != NULL)
      ibc = ibcibf[ibface];

    if (ibc != TRANSP_SRC_UG3_GBC)
    {
      for (ifn = 0; ifn <= 2; ++ifn)
      {
        inode = inibf[ibface][ifn];

        xmnmx[0][0] = MIN (xmnmx[0][0], x[inode][0]);
        xmnmx[1][0] = MAX (xmnmx[1][0], x[inode][0]);
        xmnmx[0][1] = MIN (xmnmx[0][1], x[inode][1]);
        xmnmx[1][1] = MAX (xmnmx[1][1], x[inode][1]);
        xmnmx[0][2] = MIN (xmnmx[0][2], x[inode][2]);
        xmnmx[1][2] = MAX (xmnmx[1][2], x[inode][2]);
      }
    }
  }

  jbo = 0;

  for (ibo = 1; ibo <= nbo; ++ibo)
  {
    mtransp = 0;

    if (ibcibf != NULL)
    {
      ibface = 1;

      do
      {
        if (iboibf[ibface] == ibo)
        {
          ibc = ibcibf[ibface];

          mtransp = CHK_TRANSP_UG3_GBC (ibc);
        }

        ++ibface;
      }
      while (ibface <= nbface && mtransp == 0);
    }

    if (mtransp == 0)
    {
      mbvls = -1;

      idir = 0;

      do
      {
        imnmx = 0;

        do
        {
          jnode = 0;

          xm = xmnmx[1-imnmx][idir];

          for (ibface = 1; ibface <= nbface; ++ibface)
          {
            if (iboibf[ibface] == ibo)
            {
              for (ibfn = 0; ibfn <= 2; ++ibfn)
              {
                inode = inibf[ibface][ibfn];

                if ((imnmx == 0 && x[inode][idir] < xm) ||
                    (imnmx == 1 && x[inode][idir] > xm))
                {
                  jbface = ibface;

                  jnode = inode;

                  xm = x[inode][idir];
                }
              }
            }
          }

          if (jnode)
          {
            ibface = 0;

            mbvls = ug3_bv_ls (&jbface, jnode, nbface, ibfibf, inibf,
                               bv, NULL, x);
          }

          ++imnmx;
        }
        while (imnmx <= 1 && mbvls != 0);

        ++idir;
      }
      while (idir <= 2 && mbvls != 0);

      if (mbvls != 0)
      {
        ug_error_message ("*** ERROR 312 : unable to check boundary object face ordering ***");
        return (312);
      }

      --imnmx;

      --idir;

      mext = (xm == xmnmx[imnmx][idir] && mopen <= 1) ? 1 : 0;

      if (mext == 1)
      {
        jbo = ibo;

        if (mmsg == 2)
        {
          snprintf (Text, sizeof(Text), "Boundary Objects   : External Object   =%10i", (int) ibo);
          ug_message (Text);
        }
      }

      if ((mext != imnmx && bv[idir] < dc0) ||
          (mext == imnmx && bv[idir] > dc0))
      {
        if (mmsg == 2)
        {
          snprintf (Text, sizeof(Text), "Boundary Objects   : Re-Ordered Object =%10i", (int) ibo);
          ug_message (Text);
        }

        for (ibface = 1; ibface <= nbface; ++ibface)
        {
          if (iboibf[ibface] == ibo)
          {
            ibface2 = ibfibf[ibface][1];
            ibface3 = ibfibf[ibface][2];

            inode2 = inibf[ibface][1];
            inode3 = inibf[ibface][2];

            ibfibf[ibface][1] = ibface3;
            ibfibf[ibface][2] = ibface2;

            inibf[ibface][1] = inode3;
            inibf[ibface][2] = inode2;

            if (irfibf != NULL)
            {
              irf0 = irfibf[ibface];

              irf3 = irf0 / 4;
              irf0 = irf0 - 4 * irf3;
              irf2 = irf0 / 2;
              irf1 = irf0 - irf2 - irf2;

              irfibf[ibface] = irf1 + irf3 + irf3 + 4 * irf2;
            }
          }
        }
      }
    }
  }

  if (jbo == 0 && mopen <= 1)
  {
    if (ibcibf == NULL)
    {
      ug_error_message ("*** ERROR 307 : unable to find an external boundary ***");
      return (307);
    }

    ibo = 1;

    do
    {
      mtransp = 1;

      ibface = 1;

      do
      {
        if (iboibf[ibface] == ibo)
        {
          ibc = ibcibf[ibface];

          mtransp = CHK_TRANSP_UG3_GBC (ibc);
        }

        ++ibface;
      }
      while (ibface <= nbface && mtransp == 1);

      if (mtransp == 1)
      {
        mext = 0;

        idir = 0;

        do
        {
          imnmx = 0;

          do
          {
            ibface = 1;

            do
            {
              if (iboibf[ibface] == ibo)
              {
                ibfn = 0;

                do
                {
                  inode = inibf[ibface][ibfn];

                  mext = (x[inode][idir] == xmnmx[imnmx][idir]) ? 1 : 0;

                  ++ibfn;
                }
                while (ibfn <= 2 && mext == 0);
              }

              ++ibface;
            }
            while (ibface <= nbface && mext == 0);

            ++imnmx;
          }
          while (imnmx <= 1 && mext == 0);

          ++idir;
        }
        while (idir <= 2 && mext == 0);

        if (mext == 1)
        {
          jbo = ibo;

          ierr = 0;

          if (merr)
          {
            for (ibface = 1; ibface <= nbface; ++ibface)
            {
              ierribf[ibface] = 0;
            }
          }

          for (ibface = 1; ibface <= nbface; ++ibface)
          {
            if (iboibf[ibface] == jbo)
            {
              ibface1 = ibfibf[ibface][0];
              ibface2 = ibfibf[ibface][1];
              ibface3 = ibfibf[ibface][2];

              if (ibface1 <= 0 || ibface2 <= 0 || ibface3 <= 0)
              {
                ierr = 1;

                if (merr)
                  ierribf[ibface] = -1;
                else
                {
                  ug_error_message ("*** ERROR 333 : unable to find an external boundary ***");
                  return (333);
                }
              }
            }
          }

          if (ierr == 1)
          {
            ug_error_message ("*** ERROR 200317 : boundary surface for external object is not fully connected ***");
            ug_error_message ("*** boundary faces found without neighbor(s) ***");
            ug_error_message ("*** there may be extra boundary faces unconnected ***");
            ug_error_message ("*** or partially connected to surface ***");
            ug_error_message ("*** there may be a hole in the boundary surface ***");
            return (200317);
          }

          if (merr)
          {
            for (ibface = 1; ibface <= nbface; ++ibface)
            {
              ierribf[ibface] = (iboibf[ibface] == jbo) ? -1: 0;
            }

            ug_error_message ("*** ERROR 200318 : external boundary object has transparent/embedded faces ***");
            return (200318);
          }
          else
          {
            ug_error_message ("*** ERROR 328 : external boundary object has transparent/embedded faces ***");
            return (328);
          }
        }
      }

      ++ibo;
    }
    while (ibo <= nbo && jbo == 0);

    ug_error_message ("*** ERROR 307 : unable to find an external boundary ***");
    return (307);
  }

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    ibo = iboibf[ibface];

    if (ibo == 1)
      iboibf[ibface] = jbo;
    else if (ibo == jbo)
      iboibf[ibface] = 1;
  }

  ierr = 0;

  if (merr)
  {
    for (ibface = 1; ibface <= nbface; ++ibface)
    {
      ierribf[ibface] = 0;
    }
  }

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    ibo = iboibf[ibface];

    if (ibo == 1)
    {
      ibface1 = ibfibf[ibface][0];
      ibface2 = ibfibf[ibface][1];
      ibface3 = ibfibf[ibface][2];

      if (ibface1 <= 0 || ibface2 <= 0 || ibface3 <= 0)
      {
        ierr = 1;

        if (merr)
          ierribf[ibface] = -1;
        else
        {
          ug_error_message ("*** ERROR 327 : boundary surface for external object is not fully connected ***");
          return (327);
        }
      }
    }
  }

  if (ierr == 1)
  {
    ug_error_message ("*** ERROR 200317 : boundary surface for external object is not fully connected ***");
    ug_error_message ("*** boundary faces found without neighbor(s) ***");
    ug_error_message ("*** there may be extra boundary faces unconnected ***");
    ug_error_message ("*** or partially connected to surface ***");
    ug_error_message ("*** there may be a hole in the boundary surface ***");
    return (200317);
  }

  return (0);

}

