#include "UG3_LIB.h"

void ug3_iboibf2
 (INT_ mmsg,
  INT_ nbface,
  INT_ *nbo,
  INT_ *nbo_ff,
  INT_ *nbo_int,
  INT_ *nbo_transp,
  INT_1D * ibcibf,
  INT_3D * ibfibf,
  INT_1D * jboibo,
  INT_1D * mchkbf,
  INT_1D * iboibf)

{

/*
 * Determine the number of boundary objects. Treat surfaces with a far-field,
 * BL intersecting grid BC, or transparent grid BC as separate objects.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_iboibf2.c,v 1.6 2022/11/21 00:25:14 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_133 Text;

  INT_ ibface, ibfn, ibo, ichk, ichk1, ichk2, jbface, jbo, jchk, mfound;

  if (iboibf == NULL)
    return;

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    iboibf[ibface] = 0;
  }

  ibface = 1;

  ibo = 0;

  do
  {
    ++ibo;

    ichk = 1;

    mchkbf[ichk] = ibface;

    iboibf[ibface] = ibo;

    ichk2 = 0;

    do
    {
      ichk1 = ichk2 + 1;
      ichk2 = ichk;

      for (jchk = ichk1; jchk <= ichk2; ++jchk)
      {
        jbface = mchkbf[jchk];

        for (ibfn = 0; ibfn <= 2; ++ibfn)
        {
          ibface = ibfibf[jbface][ibfn];

	  if (ibface > 0)
	  {
            if (iboibf[ibface] == 0 &&
                ((ibcibf[jbface] == FARFIELD_UG3_GBC && ibcibf[ibface] == FARFIELD_UG3_GBC) ||
                 (CHK_BL_INT_UG3_GBC (ibcibf[jbface]) == 0 && CHK_BL_INT_UG3_GBC (ibcibf[ibface]) == 0) ||
                 ((ibcibf[jbface] != FARFIELD_UG3_GBC && ibcibf[ibface] != FARFIELD_UG3_GBC) &&
                  (CHK_BL_INT_UG3_GBC (ibcibf[jbface]) && CHK_BL_INT_UG3_GBC (ibcibf[ibface])))))
            {
              ++ichk;

              mchkbf[ichk] = ibface;

              iboibf[ibface] = ibo;
            }
          }
        }
      }
    }
    while (ichk > ichk2);

    mfound = 0;

    ibface = 0;

    do
    {
      ++ibface;

      if (iboibf[ibface] == 0)
        mfound = 1;
    }
    while (ibface < nbface && mfound == 0);
  }
  while (mfound == 1);

  *nbo = ibo;
  *nbo_ff = 0;
  *nbo_int = 0;
  *nbo_transp = 0;

  for (ibo = 1; ibo <= *nbo; ++ibo)
  {
    mfound = 0;

    ibface = 1;

    do
    {
      if (iboibf[ibface] == ibo)
      {
        if (ibcibf[ibface] == FARFIELD_UG3_GBC)
          mfound = 1;
	else if (CHK_BL_INT_UG3_GBC (ibcibf[ibface]))
          mfound = 2;
	else if (CHK_TRANSP_UG3_GBC (ibcibf[ibface]))
          mfound = 3;
      }

      ++ibface;
    }
    while (ibface <= nbface && mfound == 0);

    mchkbf[ibo] = mfound;

    if (mfound == 1)
      ++(*nbo_ff);
    else if (mfound == 2)
      ++(*nbo_int);
    else if (mfound == 3)
      ++(*nbo_transp);
  }

  jbo = 0;

  for (mfound = 0; mfound <= 3; ++mfound)
  {
    for (ibo = 1; ibo <= *nbo; ++ibo)
    {
      if (mchkbf[ibo] == mfound)
      {
        ++jbo;

        jboibo[ibo] = jbo;
      }
    }
  }

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    iboibf[ibface] = jboibo[iboibf[ibface]];
  }

  if (mmsg == 2)
  {
    snprintf (Text, sizeof(Text), "Boundary Objects   : Total Objects     =%10i", (int) *nbo);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "                     FF Objects        =%10i", (int) *nbo_ff);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "                     BL_int Objects    =%10i", (int) *nbo_int);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "                     TransparentObjects=%10i", (int) *nbo_transp);
    ug_message (Text);
  }

  return;

}
