#include "UG3_LIB.h"

INT_ ug3_iboibf0
 (INT_ mmsg,
  INT_ nbface,
  INT_ *nbo,
  INT_1D * ibcibf,
  INT_1D ** iboibf,
  INT_3D * inibf,
  DOUBLE_3D * x)

{

/*
 * Determine body map treating closed boundary objects as separate bodies and
 * ignoring all transparent bodies. A closed boundary object is assumed to be
 * transparent if one or more faces of the object have a transparent grid BC.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_iboibf0.c,v 1.11 2021/03/03 03:38:44 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_3D *ibfibf = NULL;
  INT_1D *ibfichk = NULL;
  INT_1D *ibfin = NULL;
  INT_1D *ierribf = NULL;
  INT_1D *irfibf = NULL;
  INT_1D *libfin = NULL;
  INT_1D *mchkbf = NULL;

  INT_ found, ibo, ibface, jbo;
  INT_ ierr = 0;
  INT_ mclosed = 1;
  INT_ merr = 0;
  INT_ mmultc = 1;
  INT_ mopen = 0;
  INT_ mreorder = 0;
  INT_ nbfpntd = 0;
  INT_ nbfpnt = 0;
  INT_ nnode = 0;

  ug3_nnodeb (nbface, 0, &nnode, inibf, NULL);

  ibfibf = (INT_3D *) ug_malloc (&ierr, (nbface+1) * sizeof (INT_3D));
  ibfichk = (INT_1D *) ug_malloc (&ierr, (nbface+1) * sizeof (INT_1D));
  *iboibf = (INT_1D *) ug_malloc (&ierr, (nbface+1) * sizeof (INT_1D));
  libfin = (INT_1D *) ug_malloc (&ierr, (nnode+2) * sizeof (INT_1D));
  mchkbf = (INT_1D *) ug_malloc (&ierr, (nbface+1) * sizeof (INT_1D));

  if (ierr)
  {
    ug_error_message ("*** ERROR 100334 : unable to allocate required memory ***");
    ierr = 100334;
  }

  if (ierr == 0)
    ierr = ug3_ibfin (nbface, &nbfpntd, nnode, &nbfpnt, inibf, &ibfin, libfin);

  if (ierr == 0)
    ierr = ug3_ibfibf (merr, mmsg, mmultc, mreorder, nbface,
                       ibcibf, ibfin, inibf, irfibf, NULL,
                       libfin, ibfichk, mchkbf, ibfibf, ierribf,
                       x);

  if (ierr == 0)
    ug3_iboibf (mmsg, nbface, nbo, ibfibf, mchkbf, *iboibf);

  if (ierr == 0)
    ierr = ug3_ibor (mclosed, merr, mmsg, mopen, nbface, *nbo,
                     ibcibf, ibfibf, *iboibf, ierribf, inibf, irfibf,
                     x);

  ug_free (ibfibf);
  ug_free (ibfichk);
  ug_free (ibfin);
  ug_free (libfin);
  ug_free (mchkbf);

  if (ierr == 0 && ibcibf)
  {
    jbo = 1;

    for (ibo = 2; ibo <= *nbo; ibo++)
    {
      found = 0;

      for (ibface = 1; ibface <= nbface; ibface++)
      {
        if ((*iboibf)[ibface] == ibo)
        {
          if (CHK_TRANSP_UG3_GBC (ibcibf[ibface]) == 0)
            found = 1;
        }
      }

      if (found)
      {
        for (ibface = 1; ibface <= nbface; ibface++)
        {
          if ((*iboibf)[ibface] == ibo)
          {
            if (found == 1)
            {
              jbo++;

              found++;
            }

            (*iboibf)[ibface] = jbo;
          }
        }
      }
      else
      {
        for (ibface = 1; ibface <= nbface; ibface++)
        {
          if ((*iboibf)[ibface] == ibo)
            (*iboibf)[ibface] = 0;
        }
      }
    }

    *nbo = jbo;
  }

  return (ierr);
}
