#include "UG3_LIB.h"

INT_ ug3_ibfibf2
 (INT_ merr,
  INT_ mmsg,
  INT_ mmultc,
  INT_ mreorder,
  INT_ nbface,
  INT_1D * ibcibf,
  INT_3D * inibf,
  INT_1D * irfibf,
  INT_3D * isdibf,
  INT_3D ** ibfibf,
  INT_1D * ierribf,
  DOUBLE_3D * x)

{

/*
 * Determine boundary face to boundary face connectivity. Simply connected (no
 * more than two boundary faces per boundary edge) surfaces are reordered if all
 * faces do not have the same orientation. This version creates its own
 * temporary work arrays.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_ibfibf2.c,v 1.4 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_1D *ibfichk = NULL;
  INT_1D *ibfin = NULL;
  INT_1D *libfin = NULL;
  INT_1D *mchkbf = NULL;

  INT_ nbfpnt, nnodeb;
  INT_ ierr = 0;
  INT_ nbfpntd = 0;

  *ibfibf = NULL;

  // get number of boundary nodes

  ug3_nnodeb (nbface, 0, &nnodeb, inibf, NULL);

  // allocate temporary space

  *ibfibf = (INT_3D *) ug_malloc (&ierr, (nbface+1) * sizeof (INT_3D));
  ibfichk = (INT_1D *) ug_malloc (&ierr, (nbface+1) * sizeof (INT_1D));
  libfin = (INT_1D *) ug_malloc (&ierr, (nnodeb+2) * sizeof (INT_1D));
  mchkbf = (INT_1D *) ug_malloc (&ierr, (nbface+1) * sizeof (INT_1D));

  if (ierr)
  {
    ug_error_message ("*** ERROR 100307 : unable to allocate required memory ***");
    ierr = 100307;
  }

  // set surface mesh neighbor map and reorder if needed

  if (ierr == 0)
    ierr = ug3_ibfin (nbface, &nbfpntd, nnodeb, &nbfpnt, inibf, &ibfin, libfin);

  if (ierr == 0)
    ierr = ug3_ibfibf (merr, mmsg, mmultc, mreorder, nbface,
                       ibcibf, ibfin, inibf, irfibf, isdibf,
                       libfin, ibfichk, mchkbf, *ibfibf, ierribf,
                       x);

  // free temporary space

  ug_free (ibfichk);
  ug_free (ibfin);
  ug_free (libfin);
  ug_free (mchkbf);

  return (ierr);
}
