#include "UG3_LIB.h"

void ug3_face_area
 (INT_ inode1,
  INT_ inode2,
  INT_ inode3,
  double *a1231,
  double *a1232,
  double *a1233,
  double *a123s,
  DOUBLE_3D * x)

{

/*
 * Determine face area vector
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_face_area.c,v 1.4 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 * 
 */

  double dx211, dx212, dx213, 
         dx311, dx312, dx313, 
         x11, x12, x13, x21, x22, x23, x31, x32, x33;

  x11 = x[inode1][0];
  x12 = x[inode1][1];
  x13 = x[inode1][2];
  x21 = x[inode2][0];
  x22 = x[inode2][1];
  x23 = x[inode2][2];
  x31 = x[inode3][0];
  x32 = x[inode3][1];
  x33 = x[inode3][2];

  dx211 = x21 - x11;
  dx212 = x22 - x12;
  dx213 = x23 - x13;
  dx311 = x31 - x11;
  dx312 = x32 - x12;
  dx313 = x33 - x13;

  *a1231 = dx212 * dx313 - dx213 * dx312;
  *a1232 = dx213 * dx311 - dx211 * dx313;
  *a1233 = dx211 * dx312 - dx212 * dx311;
  *a123s = (*a1231) * (*a1231) + (*a1232) * (*a1232) + (*a1233) * (*a1233);

  return;
}
