#include "UG3_LIB.h"

/*
 * Determine planar face corner angle functions. The maximum value corresponds
 * to the corner with the maximum angle. The minimum value corresponds to the
 * corner with the minimum angle. 
 *
 * w# = cos (angle#) * |cos (angle#)|
 *
 * angle#	: angle between two edges sharing vertex #
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_face_ang_w.c,v 1.6 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 * 
 */

void ug3_face_ang_w
 (INT_ inode1,
  INT_ inode2,
  INT_ inode3,
  double *w1,
  double *w2,
  double *w3,
  double *w123,
  DOUBLE_3D * x)

{
  ug3_tria_face_ang_w (inode1, inode2, inode3, w1, w2, w3, x);

  *w123 = MIN (*w1, *w2);
  *w123 = MIN (*w3, *w123);

  return;
}

void ug3_tria_face_ang_w
 (INT_ inode1,
  INT_ inode2,
  INT_ inode3,
  double *w1,
  double *w2,
  double *w3,
  DOUBLE_3D * x)

{
  double dc0, dc1,
         dx211, dx212, dx213, dx21s, 
         dx311, dx312, dx313, dx31s, 
         dx321, dx322, dx323, dx32s, 
         x11, x12, x13, x21, x22, x23, x31, x32, x33;

  dc0 = 0.0;
  dc1 = 1.0;

  x11 = x[inode1][0];
  x12 = x[inode1][1];
  x13 = x[inode1][2];
  x21 = x[inode2][0];
  x22 = x[inode2][1];
  x23 = x[inode2][2];
  x31 = x[inode3][0];
  x32 = x[inode3][1];
  x33 = x[inode3][2];

  dx211 = x21 - x11;
  dx212 = x22 - x12;
  dx213 = x23 - x13;
  dx311 = x31 - x11;
  dx312 = x32 - x12;
  dx313 = x33 - x13;
  dx321 = x31 - x21;
  dx322 = x32 - x22;
  dx323 = x33 - x23;

  dx21s = dx211 * dx211 + dx212 * dx212 + dx213 * dx213;
  dx31s = dx311 * dx311 + dx312 * dx312 + dx313 * dx313;
  dx32s = dx321 * dx321 + dx322 * dx322 + dx323 * dx323;

  if (dx21s > dc0 && dx31s > dc0 && dx32s > dc0)
  {
    *w1 =   dx211 * dx311 + dx212 * dx312 + dx213 * dx313;
    *w2 = - dx211 * dx321 - dx212 * dx322 - dx213 * dx323;
    *w3 =   dx321 * dx311 + dx322 * dx312 + dx323 * dx313;

    *w1 = *w1 * fabs (*w1) / (dx21s * dx31s);
    *w2 = *w2 * fabs (*w2) / (dx21s * dx32s);
    *w3 = *w3 * fabs (*w3) / (dx32s * dx31s);
  }
  else
  {
    *w1 = -dc1;
    *w2 = -dc1;
    *w3 = -dc1;
  }

  return;
}

void ug3_quad_face_ang_w
 (INT_ inode1,
  INT_ inode2,
  INT_ inode3,
  INT_ inode4,
  double *w1,
  double *w2,
  double *w3,
  double *w4,
  DOUBLE_3D * x)

{

  double dc0, dc1,
         dx211, dx212, dx213, dx21s, 
         dx321, dx322, dx323, dx32s, 
         dx411, dx412, dx413, dx41s, 
         dx431, dx432, dx433, dx43s, 
         x11, x12, x13, x21, x22, x23, x31, x32, x33, x41, x42, x43;

  dc0 = 0.0;
  dc1 = 1.0;

  x11 = x[inode1][0];
  x12 = x[inode1][1];
  x13 = x[inode1][2];
  x21 = x[inode2][0];
  x22 = x[inode2][1];
  x23 = x[inode2][2];
  x31 = x[inode3][0];
  x32 = x[inode3][1];
  x33 = x[inode3][2];
  x41 = x[inode4][0];
  x42 = x[inode4][1];
  x43 = x[inode4][2];

  dx211 = x21 - x11;
  dx212 = x22 - x12;
  dx213 = x23 - x13;
  dx321 = x31 - x21;
  dx322 = x32 - x22;
  dx323 = x33 - x23;
  dx411 = x41 - x11;
  dx412 = x42 - x12;
  dx413 = x43 - x13;
  dx431 = x41 - x31;
  dx432 = x42 - x32;
  dx433 = x43 - x33;

  dx21s = dx211 * dx211 + dx212 * dx212 + dx213 * dx213;
  dx32s = dx321 * dx321 + dx322 * dx322 + dx323 * dx323;
  dx41s = dx411 * dx411 + dx412 * dx412 + dx413 * dx413;
  dx43s = dx431 * dx431 + dx432 * dx432 + dx433 * dx433;

  if (dx21s > dc0 && dx32s > dc0 && dx41s > dc0 && dx43s > dc0)
  {
    *w1 =   dx211 * dx411 + dx212 * dx412 + dx213 * dx413;
    *w2 = - dx211 * dx321 - dx212 * dx322 - dx213 * dx323;
    *w3 = - dx321 * dx431 - dx322 * dx432 - dx323 * dx433;
    *w4 =   dx411 * dx431 + dx412 * dx432 + dx413 * dx433;

    *w1 = *w1 * fabs (*w1) / (dx21s * dx41s);
    *w2 = *w2 * fabs (*w2) / (dx21s * dx32s);
    *w3 = *w3 * fabs (*w3) / (dx32s * dx43s);
    *w4 = *w4 * fabs (*w4) / (dx41s * dx43s);
  }
  else
  {
    *w1 = -dc1;
    *w2 = -dc1;
    *w3 = -dc1;
    *w4 = -dc1;
  }

  return;
}
