#include "UG3_LIB.h"

INT_ ug3_extract_surf
 (INT_ igroup,
  INT_ nbface_global,
  INT_ nnode_global,
  INT_ nquad_global,
  INT_ *nbface,
  INT_ *nnode,
  INT_ *nquad,
  INT_1D * ibcibf_global,
  INT_1D * idibf_global,
  INT_1D * igibf_global,
  INT_3D * inibf_global,
  INT_4D * iniq_global,
  INT_1D * iqibf_global,
  INT_1D * irfibf_global,
  INT_1D ** ibcibf,
  INT_1D ** idibf,
  INT_3D ** inibf,
  INT_4D ** iniq,
  INT_1D ** iqibf,
  INT_1D ** irfibf,
  DOUBLE_1D * del_global,
  DOUBLE_1D * ds_global,
  DOUBLE_2D * u_global,
  DOUBLE_3D * x_global,
  DOUBLE_1D ** del,
  DOUBLE_1D ** ds,
  DOUBLE_2D ** u,
  DOUBLE_3D ** x)

{

/*
 * Extract a component surface grid corresponding to a given surface ID.
 *
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_extract_surf.c,v 1.19 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_1D *inin_global = NULL;

  INT_ ibface, inode, iquad, jbface, jnode, jquad;
  INT_ ierr = 0;

  *nbface = 0;
  *nnode = 0;
  *nquad = 0;

  *ibcibf = NULL;
  *idibf = NULL;
  *iqibf = NULL;
  *irfibf = NULL;
  *inibf = NULL;
  *iniq = NULL;
  *del = NULL;
  *ds = NULL;
  *u = NULL;
  *x = NULL;

  inin_global = (INT_1D *) ug_malloc (&ierr, (nnode_global+1) * sizeof (INT_1D));

  if (ierr)
  {
    ug_free (inin_global);
    ug_error_message ("*** ERROR 100330 : unable to allocate required memory ***");
    return (100330);
  }

  ug_set_int (1, nnode_global, 0, inin_global);

  ibface = 0;

  for (jbface = 1; jbface <= nbface_global; ++jbface)
  {
    if (igibf_global == NULL || igibf_global[jbface] == igroup)
    {
      ++ibface;

      inin_global[inibf_global[jbface][0]] = 1;
      inin_global[inibf_global[jbface][1]] = 1;
      inin_global[inibf_global[jbface][2]] = 1;
    }
  }

  *nbface = ibface;

  iquad = 0;

  for (jquad = 1; jquad <= nquad_global; ++jquad)
  {
    if (igibf_global == NULL || igibf_global[nbface_global+jquad] == igroup)
    {
      ++iquad;

      inin_global[iniq_global[jquad][0]] = 1;
      inin_global[iniq_global[jquad][1]] = 1;
      inin_global[iniq_global[jquad][2]] = 1;
      inin_global[iniq_global[jquad][3]] = 1;
    }
  }

  *nquad = iquad;

  inode = 0;

  for (jnode = 1; jnode <= nnode_global; ++jnode)
  {
    if (inin_global[jnode])
    {
      ++inode;

      inin_global[jnode] = inode;
    }
  }

  *nnode = inode;

  if (ibcibf_global) *ibcibf = (INT_1D *) ug_malloc (&ierr, ((*nbface)+(*nquad)+1) * sizeof (INT_1D));
  if (idibf_global)  *idibf = (INT_1D *) ug_malloc (&ierr, ((*nbface)+(*nquad)+1) * sizeof (INT_1D));
  if (iqibf_global)  *iqibf = (INT_1D *) ug_malloc (&ierr, ((*nbface)+(*nquad)+1) * sizeof (INT_1D));
  if (irfibf_global) *irfibf = (INT_1D *) ug_malloc (&ierr, ((*nbface)+(*nquad)+1) * sizeof (INT_1D));
  if (*nbface)       *inibf = (INT_3D *) ug_malloc (&ierr, ((*nbface)+1) * sizeof (INT_3D));
  if (*nquad)        *iniq = (INT_4D *) ug_malloc (&ierr, ((*nquad)+1) * sizeof (INT_4D));
  if (del_global)    *del = (DOUBLE_1D *) ug_malloc (&ierr, ((*nnode)+1) * sizeof (DOUBLE_1D));
  if (ds_global)     *ds = (DOUBLE_1D *) ug_malloc (&ierr, ((*nnode)+1) * sizeof (DOUBLE_1D));
  if (u_global)      *u = (DOUBLE_2D *) ug_malloc (&ierr, ((*nnode)+1) * sizeof (DOUBLE_2D));
                     *x = (DOUBLE_3D *) ug_malloc (&ierr, ((*nnode)+1) * sizeof (DOUBLE_3D));

  if (ierr)
  {
    ug_free (inin_global);
    ug_error_message ("*** ERROR 100331 : unable to allocate required memory ***");
    return (100331);
  }

  for (jnode = 1; jnode <= nnode_global; ++jnode)
  {
    inode = inin_global[jnode];

    if (inode)
    {
      (*x)[inode][0] = x_global[jnode][0];
      (*x)[inode][1] = x_global[jnode][1];
      (*x)[inode][2] = x_global[jnode][2];

      if (u_global)
      {
        (*u)[inode][0] = u_global[jnode][0];
        (*u)[inode][1] = u_global[jnode][1];
      }

      if (del_global)
        (*del)[inode] = del_global[jnode];

      if (ds_global)
        (*ds)[inode] = ds_global[jnode];
    }
  }

  if (*nbface)
  {
    ibface = 0;

    for (jbface = 1; jbface <= nbface_global; ++jbface)
    {
      if (igibf_global == NULL || igibf_global[jbface] == igroup)
      {
        ++ibface;

        (*inibf)[ibface][0] = inin_global[inibf_global[jbface][0]];
        (*inibf)[ibface][1] = inin_global[inibf_global[jbface][1]];
        (*inibf)[ibface][2] = inin_global[inibf_global[jbface][2]];

        if (ibcibf_global)
          (*ibcibf)[ibface] = ibcibf_global[jbface];

        if (idibf_global)
          (*idibf)[ibface] = idibf_global[jbface];

        if (iqibf_global)
          (*iqibf)[ibface] = iqibf_global[jbface];

        if (irfibf_global)
          (*irfibf)[ibface] = irfibf_global[jbface];
      }
    }
  }

  if (*nquad)
  {
    iquad = 0;

    for (jquad = 1; jquad <= nquad_global; ++jquad)
    {
      if (igibf_global == NULL || igibf_global[nbface_global+jquad] == igroup)
      {
        ++iquad;

        (*iniq)[iquad][0] = inin_global[iniq_global[jquad][0]];
        (*iniq)[iquad][1] = inin_global[iniq_global[jquad][1]];
        (*iniq)[iquad][2] = inin_global[iniq_global[jquad][2]];
        (*iniq)[iquad][3] = inin_global[iniq_global[jquad][3]];

        if (ibcibf_global)
          (*ibcibf)[(*nbface)+iquad] = ibcibf_global[nbface_global+jquad];

        if (idibf_global)
          (*idibf)[(*nbface)+iquad] = idibf_global[nbface_global+jquad];

        if (iqibf_global)
          (*iqibf)[(*nbface)+iquad] = 0;

        if (irfibf_global)
          (*irfibf)[(*nbface)+iquad] = 0;
      }
    }
  }

  ug_free (inin_global);

  return (0);

}
