#include "UG3_LIB.h"

INT_ ug3_extract_p1_mesh_p2 (INT_ nbface,
                             INT_ nelem,
                             INT_ nnode,
                             INT_ *p1_nbface,
                             INT_ *p1_nelem,
                             INT_ *p1_nnode,
                             INT_1D * ibcibf,
                             INT_1D * idibf,
                             INT_1D * iqibf,
                             INT_3D * inibf,
                             INT_1D * idiel,
                             INT_4D * iniel,
                             DOUBLE_1D * ds,
                             DOUBLE_1D * del,
                             DOUBLE_3D * x,
                             DOUBLE_6D * met,
                             INT_1D ** p1_ibcibf,
                             INT_1D ** p1_idibf,
                             INT_1D ** p1_iqibf,
                             INT_3D ** p1_inibf,
                             INT_1D ** p1_idiel,
                             INT_4D ** p1_iniel,
                             DOUBLE_1D ** p1_ds,
                             DOUBLE_1D ** p1_del,
                             DOUBLE_3D ** p1_x,
                             DOUBLE_6D ** p1_met)
{

/*
 * Extract a p1 complement mesh from a p2 mesh defined by a p1+p2 complement 
 * mesh. Note that it is assumed that the p1+p2 complement mesh does not have
 * any quad-faces, prism-elements, pyramid-elements, or hex-elements.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_extract_p1_mesh_p2.c,v 1.7 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_1D *p1_node_map = NULL;
  INT_1D *p2_node_map = NULL;

  INT_ ibface, ielem, inode, inode1, inode2, inode3, inode4, nnodeb, p1_inode;
  INT_ ierr = 0;
 
  // allocate node map

  ug3_nnodeb (nbface, 0, &nnodeb, inibf, NULL);

  p1_node_map = (INT_1D *) ug_malloc (&ierr, (nnode+1) * sizeof (INT_1D));
  p2_node_map = (INT_1D *) ug_malloc (&ierr, (nnode+1) * sizeof (INT_1D));

  if (ierr)
  {
    ug_free (p1_node_map);
    ug_free (p2_node_map);
    ug_error_message ("*** ERROR 100351 : unable to allocate required memory ***");
    return 100351;
  }

  memset (p1_node_map, 0, (nnode+1)*sizeof (INT_1D));

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    inode1 = inibf[ibface][0];
    inode2 = inibf[ibface][1];
    inode3 = inibf[ibface][2];

    p1_node_map[inode1] = 1;
    p1_node_map[inode2] = 1;
    p1_node_map[inode3] = 1;
  }

  p1_inode = 0;

  for (inode = 1; inode <= nnodeb; ++inode)
  {
    if (p1_node_map[inode] == 1)
    {
      p1_inode++;

      p1_node_map[p1_inode] = inode;
      p2_node_map[inode] = p1_inode;
    }
  }

  for (ielem = 1; ielem <= nelem; ++ielem)
  {
    inode1 = iniel[ielem][0];
    inode2 = iniel[ielem][1];
    inode3 = iniel[ielem][2];
    inode4 = iniel[ielem][3];

    p1_node_map[inode1] = -1;
    p1_node_map[inode2] = -1;
    p1_node_map[inode3] = -1;
    p1_node_map[inode4] = -1;
  }

  for (inode = 1; inode <= nnode; ++inode)
  {
    if (p1_node_map[inode] == -1)
    {
      p1_inode++;

      p1_node_map[p1_inode] = inode;
      p2_node_map[inode] = p1_inode;
    }
  }

  // set size of p1 complement

  if (iniel == NULL) nelem = 0;

  *p1_nbface = nbface;
  *p1_nelem = nelem;
  *p1_nnode = p1_inode;

  // allocate p1 complement

  *p1_ibcibf = NULL;
  *p1_idibf = NULL;
  *p1_iqibf = NULL;
  *p1_inibf = NULL;
  *p1_idiel = NULL;
  *p1_iniel = NULL;

  *p1_ds = NULL;
  *p1_del = NULL;
  *p1_x = NULL;
  *p1_met = NULL;

  if (ibcibf)
    *p1_ibcibf = (INT_1D *) ug_malloc (&ierr, ((*p1_nbface)+1) * sizeof (INT_1D));
  *p1_idibf = (INT_1D *) ug_malloc (&ierr, ((*p1_nbface)+1) * sizeof (INT_1D));
  if (iqibf)
    *p1_iqibf = (INT_1D *) ug_malloc (&ierr, ((*p1_nbface)+1) * sizeof (INT_1D));
  *p1_inibf = (INT_3D *) ug_malloc (&ierr, ((*p1_nbface)+1) * sizeof (INT_3D));
  if (nelem)
  {
    if (idiel && nelem)
      *p1_idiel = (INT_1D *) ug_malloc (&ierr, ((*p1_nelem)+1) * sizeof (INT_1D));
    *p1_iniel = (INT_4D *) ug_malloc (&ierr, ((*p1_nelem)+1) * sizeof (INT_4D));
  }

  if (ds)
    *p1_ds = (DOUBLE_1D *) ug_malloc (&ierr, ((*p1_nnode)+1) * sizeof (DOUBLE_1D));
  if (del)
    *p1_del = (DOUBLE_1D *) ug_malloc (&ierr, ((*p1_nnode)+1) * sizeof (DOUBLE_1D));
  *p1_x = (DOUBLE_3D *) ug_malloc (&ierr, ((*p1_nnode)+1) * sizeof (DOUBLE_3D));
  if (met)
    *p1_met = (DOUBLE_6D *) ug_malloc (&ierr, ((*p1_nnode)+1) * sizeof (DOUBLE_6D));

  if (ierr)
  {
    ug_free (p1_node_map);
    ug_free (p2_node_map);
    ug_error_message ("*** ERROR 100352 : unable to allocate required memory ***");
    return 100352;
  }

  // create p1 complement boundary mesh tria-face connectivity and flags

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    inode1 = inibf[ibface][0];
    inode2 = inibf[ibface][1];
    inode3 = inibf[ibface][2];

    if (ibcibf) (*p1_ibcibf)[ibface] = ibcibf[ibface];
    (*p1_idibf)[ibface] = idibf[ibface];
    if (iqibf) (*p1_iqibf)[ibface] = iqibf[ibface];

    (*p1_inibf)[ibface][0] = p2_node_map[inode1];
    (*p1_inibf)[ibface][1] = p2_node_map[inode2];
    (*p1_inibf)[ibface][2] = p2_node_map[inode3];
  }

  // create p1 complement volume mesh tet-element connectivity and ID flag

  for (ielem = 1; ielem <= nelem; ++ielem)
  {
    inode1 = iniel[ielem][0];
    inode2 = iniel[ielem][1];
    inode3 = iniel[ielem][2];
    inode4 = iniel[ielem][3];

    if (*p1_idiel) (*p1_idiel)[ielem] = idiel[ielem];
    
    (*p1_iniel)[ielem][0] = p2_node_map[inode1];
    (*p1_iniel)[ielem][1] = p2_node_map[inode2];
    (*p1_iniel)[ielem][2] = p2_node_map[inode3];
    (*p1_iniel)[ielem][3] = p2_node_map[inode4];
  }

  // set p1 complement mesh coordinates and node data

  for (p1_inode = 1; p1_inode <= *p1_nnode; ++p1_inode)
  {
    inode = p1_node_map[p1_inode];

    if (ds) (*p1_ds)[p1_inode] = ds[inode];
    if (del) (*p1_del)[p1_inode] = del[inode];

    (*p1_x)[p1_inode][0] = x[inode][0];
    (*p1_x)[p1_inode][1] = x[inode][1];
    (*p1_x)[p1_inode][2] = x[inode][2];

    if (met)
    {
      (*p1_met)[p1_inode][0] = met[inode][0];
      (*p1_met)[p1_inode][1] = met[inode][1];
      (*p1_met)[p1_inode][2] = met[inode][2];
      (*p1_met)[p1_inode][3] = met[inode][3];
      (*p1_met)[p1_inode][4] = met[inode][4];
      (*p1_met)[p1_inode][5] = met[inode][5];
    }
  }

  ug_free (p1_node_map);
  ug_free (p2_node_map);

  return 0;
}
