#include "UG3_LIB.h"

void ug3_edge_length
 (INT_ nelem,
  INT_4D * iniel,
  double *emax,
  double *emin,
  DOUBLE_1D * df,
  DOUBLE_3D * x)

{

/*
 * Find maximum and minimum edge length ratios.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_edge_length.c,v 1.3 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ielem, inode1, inode2, inode3, inode4;

  double dc0, dc2, df1, df2, df3, df4,
         dx211, dx212, dx213,
         dx311, dx312, dx313,
         dx321, dx322, dx323,
         dx411, dx412, dx413,
         dx421, dx422, dx423,
         dx431, dx432, dx433,
         e21, e31, e41, e32, e42, e43,
         x11, x12, x13, x21, x22, x23, x31, x32, x33, x41, x42, x43;

  dc0 = 0.0;
  dc2 = 2.0;

  *emax = dc0;
  *emin = dc0;

  for (ielem = 1; ielem <= nelem; ++ielem)
  {
    inode1 = iniel[ielem][0];
    inode2 = iniel[ielem][1];
    inode3 = iniel[ielem][2];
    inode4 = iniel[ielem][3];

    df1 = df[inode1];
    df2 = df[inode2];
    df3 = df[inode3];
    df4 = df[inode4];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x13 = x[inode1][2];
    x21 = x[inode2][0];
    x22 = x[inode2][1];
    x23 = x[inode2][2];
    x31 = x[inode3][0];
    x32 = x[inode3][1];
    x33 = x[inode3][2];
    x41 = x[inode4][0];
    x42 = x[inode4][1];
    x43 = x[inode4][2];

    dx211 = x21 - x11;
    dx212 = x22 - x12;
    dx213 = x23 - x13;
    dx311 = x31 - x11;
    dx312 = x32 - x12;
    dx313 = x33 - x13;
    dx321 = x31 - x21;
    dx322 = x32 - x22;
    dx323 = x33 - x23;
    dx411 = x41 - x11;
    dx412 = x42 - x12;
    dx413 = x43 - x13;
    dx421 = x41 - x21;
    dx422 = x42 - x22;
    dx423 = x43 - x23;
    dx431 = x41 - x31;
    dx432 = x42 - x32;
    dx433 = x43 - x33;

    e21 = dc2 * sqrt (dx211 * dx211 + dx212 * dx212 + dx213 * dx213) / (df1 + df2);
    e31 = dc2 * sqrt (dx311 * dx311 + dx312 * dx312 + dx313 * dx313) / (df1 + df3);
    e41 = dc2 * sqrt (dx411 * dx411 + dx412 * dx412 + dx413 * dx413) / (df1 + df4);
    e32 = dc2 * sqrt (dx321 * dx321 + dx322 * dx322 + dx323 * dx323) / (df2 + df3);
    e42 = dc2 * sqrt (dx421 * dx421 + dx422 * dx422 + dx423 * dx423) / (df2 + df4);
    e43 = dc2 * sqrt (dx431 * dx431 + dx432 * dx432 + dx433 * dx433) / (df3 + df4);

    if (*emin == dc0) *emin = e21;

    *emax = MAX (*emax, e21);
    *emax = MAX (*emax, e31);
    *emax = MAX (*emax, e41);
    *emax = MAX (*emax, e32);
    *emax = MAX (*emax, e42);
    *emax = MAX (*emax, e43);
    *emin = MIN (*emin, e21);
    *emin = MIN (*emin, e31);
    *emin = MIN (*emin, e41);
    *emin = MIN (*emin, e32);
    *emin = MIN (*emin, e42);
    *emin = MIN (*emin, e43);
  }

  return;
}
