#include "UG3_LIB.h"

void ug3_dfmin
 (INT_ nbface,
  INT_ nnode,
  INT_3D * inibf,
  double cdf,
  DOUBLE_3D * x,
  DOUBLE_1D * dfmin)

{

/*
 * Determine the minimum node distribution function at all boundary nodes.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_dfmin.c,v 1.9 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ibface, inode, inode1, inode2, inode3;

  double dss, dssm, dx1, dx2, dx3,
         x11, x12, x13, x21, x22, x23, x31, x32, x33, xmax, xmin;

  inode = 1;

  xmin = x[inode][0];
  xmax = x[inode][0];

  for (inode = 2; inode <= nnode; ++inode)
  {
    xmax = MAX (xmax, x[inode][0]);
    xmax = MAX (xmax, x[inode][1]);
    xmax = MAX (xmax, x[inode][2]);

    xmin = MIN (xmin, x[inode][0]);
    xmin = MIN (xmin, x[inode][1]);
    xmin = MIN (xmin, x[inode][2]);
  }

  dss = (xmax - xmin) * (xmax - xmin);

  for (inode = 1; inode <= nnode; ++inode)
  {
    dfmin[inode] = dss;
  }

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    inode1 = inibf[ibface][0];
    inode2 = inibf[ibface][1];
    inode3 = inibf[ibface][2];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x13 = x[inode1][2];
    x21 = x[inode2][0];
    x22 = x[inode2][1];
    x23 = x[inode2][2];
    x31 = x[inode3][0];
    x32 = x[inode3][1];
    x33 = x[inode3][2];

    dx1 = x21 - x11;
    dx2 = x22 - x12;
    dx3 = x23 - x13;

    dss = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

    dssm = dss;

    dx1 = x31 - x11;
    dx2 = x32 - x12;
    dx3 = x33 - x13;

    dss = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

    dssm = MIN (dssm, dss);

    dx1 = x31 - x21;
    dx2 = x32 - x22;
    dx3 = x33 - x23;

    dss = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

    dssm = MIN (dssm, dss);

    dfmin[inode1] = MIN (dfmin[inode1], dssm);
    dfmin[inode2] = MIN (dfmin[inode2], dssm);
    dfmin[inode3] = MIN (dfmin[inode3], dssm);
  }

  for (inode = 1; inode <= nnode; ++inode)
  {
    dfmin[inode] = cdf * sqrt (dfmin[inode]);
  }

  return;

}
