#include "UG3_LIB.h"

void ug3_dfmax
 (INT_ nbface,
  INT_ nnode,
  INT_3D * inibf,
  double cdf,
  DOUBLE_3D * x,
  DOUBLE_1D * dfmax)

{

/*
 * Determine the maximum node distribution function at all boundary nodes.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_dfmax.c,v 1.7 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ibface, inode, inode1, inode2, inode3;

  double dc0, dss, dssm, dx1, dx2, dx3, x11, x12, x13, x21, x22, x23, x31, x32,
         x33;

  dc0 = 0.0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    dfmax[inode] = dc0;
  }

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    inode1 = inibf[ibface][0];
    inode2 = inibf[ibface][1];
    inode3 = inibf[ibface][2];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x13 = x[inode1][2];
    x21 = x[inode2][0];
    x22 = x[inode2][1];
    x23 = x[inode2][2];
    x31 = x[inode3][0];
    x32 = x[inode3][1];
    x33 = x[inode3][2];

    dx1 = x21 - x11;
    dx2 = x22 - x12;
    dx3 = x23 - x13;

    dss = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

    dssm = dss;

    dx1 = x31 - x11;
    dx2 = x32 - x12;
    dx3 = x33 - x13;

    dss = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

    dssm = MAX (dssm, dss);

    dx1 = x31 - x21;
    dx2 = x32 - x22;
    dx3 = x33 - x23;

    dss = dx1 * dx1 + dx2 * dx2 + dx3 * dx3;

    dssm = MAX (dssm, dss);

    dfmax[inode1] = MAX (dfmax[inode1], dssm);
    dfmax[inode2] = MAX (dfmax[inode2], dssm);
    dfmax[inode3] = MAX (dfmax[inode3], dssm);
  }

  for (inode = 1; inode <= nnode; ++inode)
  {
    dfmax[inode] = cdf * sqrt (dfmax[inode]);
  }

  return;

}
