#include "UG3_LIB.h"

void ug3_dff
 (INT_ nbface,
  INT_ nelem,
  INT_ nnode,
  INT_ nnodeb,
  INT_3D * inibf,
  INT_4D * iniel,
  INT_1D * nnp,
  double cdf,
  DOUBLE_3D * x,
  DOUBLE_1D * df)

{

/*
 * Determine the node distribution function (df) at all nodes.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_dff.c,v 1.8 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ibface, ielem, inode, inode1, inode2, inode3, inode4, iw1, iw2, iw3, iw4,
       nnpi, nnp1, nnp2, nnp3, nnp4, mbnd;

  double dc0, df1, df2, df3, df4, df5, df6, dx1, dx2, dx3, w1, w2, w3, w4, x11,
         x12, x13, x21, x22, x23, x31, x32, x33, x41, x42, x43;

  dc0 = 0.0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    nnp[inode] = 1;

    df[inode] = dc0;
  }

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    inode1 = inibf[ibface][0];
    inode2 = inibf[ibface][1];
    inode3 = inibf[ibface][2];

    nnp[inode1] = 0;
    nnp[inode2] = 0;
    nnp[inode3] = 0;
  }

  mbnd = 1;

  if (nelem > 0)
  {
    ielem = 1;

    do
    {
      inode1 = iniel[ielem][0];
      inode2 = iniel[ielem][1];
      inode3 = iniel[ielem][2];
      inode4 = iniel[ielem][3];

      if (inode1 > nnodeb &&
          inode2 > nnodeb &&
          inode3 > nnodeb &&
          inode4 > nnodeb) mbnd = 0;

      ++ielem;
    }
    while (ielem <= nelem && mbnd == 1);
  }

  if (mbnd == 1)
  {
    for (ibface = 1; ibface <= nbface; ++ibface)
    {
      inode1 = inibf[ibface][0];
      inode2 = inibf[ibface][1];
      inode3 = inibf[ibface][2];

      x11 = x[inode1][0];
      x12 = x[inode1][1];
      x13 = x[inode1][2];
      x21 = x[inode2][0];
      x22 = x[inode2][1];
      x23 = x[inode2][2];
      x31 = x[inode3][0];
      x32 = x[inode3][1];
      x33 = x[inode3][2];

      dx1 = x21 - x11;
      dx2 = x22 - x12;
      dx3 = x23 - x13;

      df1 = sqrt (dx1 * dx1 + dx2 * dx2 + dx3 * dx3);

      dx1 = x31 - x21;
      dx2 = x32 - x22;
      dx3 = x33 - x23;

      df2 = sqrt (dx1 * dx1 + dx2 * dx2 + dx3 * dx3);

      dx1 = x11 - x31;
      dx2 = x12 - x32;
      dx3 = x13 - x33;

      df3 = sqrt (dx1 * dx1 + dx2 * dx2 + dx3 * dx3);

      df[inode1] = df[inode1] + df1 + df3;
      df[inode2] = df[inode2] + df2 + df1;
      df[inode3] = df[inode3] + df3 + df2;

      nnp[inode1] = nnp[inode1] + 2;
      nnp[inode2] = nnp[inode2] + 2;
      nnp[inode3] = nnp[inode3] + 2;
    }

    for (inode = 1; inode <= nnodeb; ++inode)
    {
      df[inode] = df[inode] / ((double) nnp[inode]);
    }

    if (nnode > nnodeb)
    {
      for (inode = 1; inode <= nnodeb; ++inode)
      {
        nnp[inode] = 1;
      }

      for (inode = nnodeb+1; inode <= nnode; ++inode)
      {
        nnp[inode] = 0;
      }

      for (ielem = 1; ielem <= nelem; ++ielem)
      {
        inode1 = iniel[ielem][0];
        inode2 = iniel[ielem][1];
        inode3 = iniel[ielem][2];
        inode4 = iniel[ielem][3];

        nnp1 = nnp[inode1];
        nnp2 = nnp[inode2];
        nnp3 = nnp[inode3];
        nnp4 = nnp[inode4];

        nnp1 = nnp[inode1];
        nnp2 = nnp[inode2];
        nnp3 = nnp[inode3];
        nnp4 = nnp[inode4];

        df1 = df[inode1];
        df2 = df[inode2];
        df3 = df[inode3];
        df4 = df[inode4];

        iw1 = MAX (MIN (nnp1, 1), 0);
        iw2 = MAX (MIN (nnp2, 1), 0);
        iw3 = MAX (MIN (nnp3, 1), 0);
        iw4 = MAX (MIN (nnp4, 1), 0);

        w1 = (double) iw1;
        w2 = (double) iw2;
        w3 = (double) iw3;
        w4 = (double) iw4;

        if (iw1 == 0)
        {
          nnp[inode1] = nnp1 - iw2 - iw3 - iw4;

          df[inode1] = df1 - w2 * df2 - w3 * df3 - w4 * df4;
        }

        if (iw2 == 0)
        {
          nnp[inode2] = nnp2 - iw1 - iw3 - iw4;

          df[inode2] = df2 - w1 * df1 - w3 * df3 - w4 * df4;
        }

        if (iw3 == 0)
        {
          nnp[inode3] = nnp3 - iw1 - iw2 - iw4;

          df[inode3] = df3 - w1 * df1 - w2 * df2 - w4 * df4;
        }

        if (iw4 == 0)
        {
          nnp[inode4] = nnp4 - iw1 - iw2 - iw3;

          df[inode4] = df4 - w1 * df1 - w2 * df2 - w3 * df3;
        }

      }

      for (inode = nnodeb+1; inode <= nnode; ++inode)
      {
        nnpi = nnp[inode];

        if (nnpi < 0)
          df[inode] = cdf * df[inode] / ((double) nnpi);
      }
    }
  }

  else
  {
    for (ielem = 1; ielem <= nelem; ++ielem)
    {
      inode1 = iniel[ielem][0];
      inode2 = iniel[ielem][1];
      inode3 = iniel[ielem][2];
      inode4 = iniel[ielem][3];

      nnp[inode1] = 0;
      nnp[inode2] = 0;
      nnp[inode3] = 0;
      nnp[inode4] = 0;
    }

    for (ielem = 1; ielem <= nelem; ++ielem)
    {
      inode1 = iniel[ielem][0];
      inode2 = iniel[ielem][1];
      inode3 = iniel[ielem][2];
      inode4 = iniel[ielem][3];

      x11 = x[inode1][0];
      x12 = x[inode1][1];
      x13 = x[inode1][2];
      x21 = x[inode2][0];
      x22 = x[inode2][1];
      x23 = x[inode2][2];
      x31 = x[inode3][0];
      x32 = x[inode3][1];
      x33 = x[inode3][2];
      x41 = x[inode4][0];
      x42 = x[inode4][1];
      x43 = x[inode4][2];

      dx1 = x21 - x11;
      dx2 = x22 - x12;
      dx3 = x23 - x13;

      df1 = sqrt (dx1 * dx1 + dx2 * dx2 + dx3 * dx3);

      dx1 = x31 - x11;
      dx2 = x32 - x12;
      dx3 = x33 - x13;

      df2 = sqrt (dx1 * dx1 + dx2 * dx2 + dx3 * dx3);

      dx1 = x41 - x11;
      dx2 = x42 - x12;
      dx3 = x43 - x13;

      df3 = sqrt (dx1 * dx1 + dx2 * dx2 + dx3 * dx3);

      dx1 = x31 - x21;
      dx2 = x32 - x22;
      dx3 = x33 - x23;

      df4 = sqrt (dx1 * dx1 + dx2 * dx2 + dx3 * dx3);

      dx1 = x41 - x21;
      dx2 = x42 - x22;
      dx3 = x43 - x23;

      df5 = sqrt (dx1 * dx1 + dx2 * dx2 + dx3 * dx3);

      dx1 = x41 - x31;
      dx2 = x42 - x32;
      dx3 = x43 - x33;

      df6 = sqrt (dx1 * dx1 + dx2 * dx2 + dx3 * dx3);

      df[inode1] = df[inode1] + df1 + df2 + df3;
      df[inode2] = df[inode2] + df1 + df4 + df5;
      df[inode3] = df[inode3] + df2 + df4 + df6;
      df[inode4] = df[inode4] + df3 + df5 + df6;

      nnp[inode1] = nnp[inode1] + 3;
      nnp[inode2] = nnp[inode2] + 3;
      nnp[inode3] = nnp[inode3] + 3;
      nnp[inode4] = nnp[inode4] + 3;
    }

    for (inode = 1; inode <= nnode; ++inode)
    {
      df[inode] = cdf * df[inode] / ((double) nnp[inode]);
    }
  }

  return;

}
