#include "UG3_LIB.h"

void ug3_dfbf
 (INT_ nbface,
  INT_3D * inibf,
  DOUBLE_3D * x,
  DOUBLE_1D * dfbf)

{

/*
 * Determine the node distribution function (df) at all boundary faces.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_dfbf.c,v 1.7 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ibface, inode1, inode2, inode3;

  double c1, dc1, dc3, dx211, dx212, dx213, dx311, dx312, dx313, dx321, dx322,
         dx323, x11, x12, x13, x21, x22, x23, x31, x32, x33;

  dc1 = 1.0;
  dc3 = 3.0;

  c1 = dc1 / sqrt (dc3);

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    inode1 = inibf[ibface][0];
    inode2 = inibf[ibface][1];
    inode3 = inibf[ibface][2];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x13 = x[inode1][2];
    x21 = x[inode2][0];
    x22 = x[inode2][1];
    x23 = x[inode2][2];
    x31 = x[inode3][0];
    x32 = x[inode3][1];
    x33 = x[inode3][2];

    dx211 = x21 - x11;
    dx212 = x22 - x12;
    dx213 = x23 - x13;
    dx311 = x31 - x11;
    dx312 = x32 - x12;
    dx313 = x33 - x13;
    dx321 = x31 - x21;
    dx322 = x32 - x22;
    dx323 = x33 - x23;

    dfbf[ibface] = c1 * sqrt (dx211 * dx211 + dx212 * dx212 + dx213 * dx213
                            + dx311 * dx311 + dx312 * dx312 + dx313 * dx313
                            + dx321 * dx321 + dx322 * dx322 + dx323 * dx323);
  }

  return;

}
