#include "UG3_LIB.h"

void ug3_dfbe
 (INT_ nbedge,
  INT_ nnode,
  INT_2D * inibe,
  INT_1D * nnp,
  double cdf,
  DOUBLE_3D * x,
  DOUBLE_1D * df)

{

/*
 * Determine the node distribution function (df) at all boundary face edge
 * nodes.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_dfbe.c,v 1.7 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ibedge, inode, inode1, inode2;

  double dc0, df0, dx211, dx212, dx213, x11, x12, x13, x21, x22, x23;

  dc0 = 0.0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    nnp[inode] = 1;

    df[inode] = dc0;
  }

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    inode1 = inibe[ibedge][0];
    inode2 = inibe[ibedge][1];

    nnp[inode1] = 0;
    nnp[inode2] = 0;
  }

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    inode1 = inibe[ibedge][0];
    inode2 = inibe[ibedge][1];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x13 = x[inode1][2];
    x21 = x[inode2][0];
    x22 = x[inode2][1];
    x23 = x[inode2][2];

    dx211 = x21 - x11;
    dx212 = x22 - x12;
    dx213 = x23 - x13;

    df0 = sqrt (dx211 * dx211 + dx212 * dx212 + dx213 * dx213);

    df[inode1] = df[inode1] + df0; 
    df[inode2] = df[inode2] + df0; 

    nnp[inode1] = nnp[inode1] + 1;
    nnp[inode2] = nnp[inode2] + 1;
  }

  for (inode = 1; inode <= nnode; ++inode)
  {
    df[inode] = cdf * df[inode] / (double)(nnp[inode]);
  }

  return;

}
