#include "UG3_LIB.h"

void ug3_df_gr_data
 (INT_ *,
  double *,
  double *,
  double *);

void ug3_df_gr
 (INT_ inode,
  INT_ nnode,
  double cdfr,
  double cdfs,
  double wi,
  double x01,
  double x02,
  double x03,
  DOUBLE_1D * df,
  DOUBLE_1D * ds,
  DOUBLE_3D * x)

{

/*
 * Interpolate with growth the distribution function from multiple nodes.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_df_gr.c,v 1.8 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  static INT_ iset_smin = 0;
  static double smin = 0.0;

  INT_ inodem;

  double csmin, dc0, dfi, dsi, dsj, dsjm, dsm, dsmin, dsminm, dx1, dx2, dx3,
         tol0, wdfsum, wm, wsum;

  dc0 = 0.0;

  csmin = 0.8;

  if (inode < 1 || inode > nnode || wi <= dc0)
    return;

  if (iset_smin == 0)
  {
    iset_smin = 1;

    ug_round_off_error (&tol0);

    smin = pow (tol0, csmin);
  }

  dfi = df[inode];

  dx1 = x01 - x[inode][0];
  dx2 = x02 - x[inode][1];
  dx3 = x03 - x[inode][2];

  dsi = sqrt (dx1 * dx1 + dx2 * dx2 + dx3 * dx3);

  if (ds != NULL)
    dsj = dsi + ds[inode];
  else
    dsj = dsi;

  inodem = 0;

  ug3_df_gr_data (&inodem, &dsmin, &wdfsum, &wsum);

  if (inodem == 0)
  {
    inodem = inode;

    dsmin = dsj;

    wdfsum = dc0;
    wsum = dc0;
  }

  else if (dsj < dsmin)
  {
    inodem = inode;

    dsmin = dsj;
  }

  dsminm = smin * dfi;

  dsjm = MAX (dsj, dsminm);

  wm = wi / (dsjm * dsjm);

  wsum = wsum + wm;

  dsm = dsi - cdfs * dfi;
  dsm = MAX (dsm, dc0);

  wdfsum = wdfsum + wm * (dfi + cdfr * dsm - dsm);

  ug3_df_gr_data (&inodem, &dsmin, &wdfsum, &wsum);

  return;

}

void ug3_df_gr_data
 (INT_ *inodem,
  double *dsmin,
  double *wdfsum,
  double *wsum)

{
/*
 * Get or set local data.
 */

  static INT_ inodem_ = 0;

  static double dsmin_ = 0.0;
  static double wdfsum_ = 0.0;
  static double wsum_ = 0.0;

  if (*inodem == 0)
  {
    *inodem = inodem_;

    *dsmin = dsmin_;
    *wdfsum = wdfsum_;
    *wsum = wsum_;
  }

  else if (*inodem > 0)
  {
    inodem_ = *inodem;

    dsmin_ = *dsmin;
    wdfsum_ = *wdfsum;
    wsum_ = *wsum;
  }

  else
    inodem_ = 0;

  return;
}

void ug3_df_gr_get
 (INT_ *inode,
  double *dfi,
  double *dsj)

{

/*
 * Get distribution function interpolated with growth from multiple nodes.
 */ 

  INT_ inodem;

  double dc0, dsmin, wdfsum, wsum;

  dc0 = 0.0;

  inodem = 0;

  ug3_df_gr_data (&inodem, &dsmin, &wdfsum, &wsum);

  if (inodem > 0)
  {
    *inode = inodem;

    *dfi = wdfsum / wsum;

    *dsj = dsmin;
  }
  else
  {
    *inode = 0;

    *dfi = dc0;

    *dsj = dc0;
  }

  inodem = -1;

  ug3_df_gr_data (&inodem, &dsmin, &wdfsum, &wsum);

  return;
}
