#include "UG3_LIB.h"

void ug3_df0f
 (INT_ nnode,
  INT_1D * ielin,
  INT_4D * iniel,
  INT_1D * lielin,
  INT_1D * mn,
  DOUBLE_1D * df)

{

/*
 * Set zero value distribution function using simple averaging.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_df0f.c,v 1.7 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ielem, iit, inode, inode1, inode2, inode3, inode4, loc, loc1, loc2, nit,
       mn1, mn2, mn3, mn4, mni, mnmax, mnmin;

  double dc0, dc1, dfsum, wsum;

  dc0 = 0.0;
  dc1 = 1.0;

  mnmax = 0;
  mnmin = 1;

  for (inode = 1; inode <= nnode; ++inode)
  {
    if (df[inode] == dc0)
    {
      mnmin = 0;

      mn[inode] = 0;
    }
    else
    {
      mnmax = 1;

      mn[inode] = 1;
    }
  }

  if (mnmax == 0 || mnmin == 1) return;

  nit = nnode;

  iit = 1;

  do
  {
    mnmin = 1;

    for (inode = 1; inode <= nnode; ++inode)
    {
      mni = mn[inode];

      if (mni == 0)
      {
        dfsum = dc0;

        wsum = dc0;

        loc1 = lielin[inode];
        loc2 = lielin[inode+1] - 1;

        for (loc = loc1; loc <= loc2; ++loc)
        {
          ielem = ielin[loc];

          inode1 = iniel[ielem][0];
          inode2 = iniel[ielem][1];
          inode3 = iniel[ielem][2];
          inode4 = iniel[ielem][3];

          mn1 = mn[inode1];
          mn2 = mn[inode2];
          mn3 = mn[inode3];
          mn4 = mn[inode4];

          if (mn1 == 1 || mn2 == 1 || mn3 == 1 || mn4 == 1)
          {
            mni = -1;

            if (mn1 == 1)
            {
              dfsum = dfsum + df[inode1];

              wsum = wsum + dc1;
            }

            if (mn2 == 1)
            {
              dfsum = dfsum + df[inode2];

              wsum = wsum + dc1;
            }

            if (mn3 == 1)
            {
              dfsum = dfsum + df[inode3];

              wsum = wsum + dc1;
            }

            if (mn4 == 1)
            {
              dfsum = dfsum + df[inode4];

              wsum = wsum + dc1;
            }
          }
        }
      }

      if (mni == 0)
        mnmin = 0;

      else if (mni == -1)
      {
        mn[inode] = 1;

        df[inode] = dfsum / wsum;
      }
    }

    ++iit;
  }
  while (iit <= nit && mnmin == 0);

  return;

}
