#include "UG3_LIB.h"

void ug3_df
 (INT_ nbface,
  INT_ nnode,
  INT_ nquad,
  INT_1D * ibcibf,
  INT_3D * inibf,
  INT_4D * iniq,
  INT_1D * nnp,
  double cdf,
  double cdf2,
  double cdff,
  DOUBLE_3D * x,
  DOUBLE_1D * df)

{

/*
 * Determine the node distribution function (df) at all boundary nodes using a
 * different factor at BL nodes and limit the maximum distribution function for
 * each face.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_df.c,v 1.10 2021/10/11 21:23:57 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ibc, ibface, inode, inode1, inode2, inode3, inode4, iquad;

  double cdfi, df1, df1m, df2, df2m, df3, df3m, df4, df4m, dfmax, dfmin,
         dfmxm, dx1, dx2, dx3, x11, x12, x13, x21, x22, x23, x31, x32, x33, x41,
         x42, x43;

  ug_set_int (1, nnode, 1, nnp);

  ug_set_double (1, nnode, 0.0, df);

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    ibc = (ibcibf == NULL) ? 1 : ibcibf[ibface];

    if (CHK_PART_UG3_GBC(ibc) == 0)
    {
      inode1 = inibf[ibface][0];
      inode2 = inibf[ibface][1];
      inode3 = inibf[ibface][2];

      nnp[inode1] = 0;
      nnp[inode2] = 0;
      nnp[inode3] = 0;
    }
  }

  for (iquad = 1; iquad <= nquad; ++iquad)
  {
    ibface = iquad + nbface;

    ibc = (ibcibf == NULL) ? 1 : ibcibf[ibface];

    if (CHK_PART_UG3_GBC(ibc) == 0)
    {
      inode1 = iniq[iquad][0];
      inode2 = iniq[iquad][1];
      inode3 = iniq[iquad][2];
      inode4 = iniq[iquad][3];

      nnp[inode1] = 0;
      nnp[inode2] = 0;
      nnp[inode3] = 0;
      nnp[inode4] = 0;
    }
  }

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    ibc = (ibcibf == NULL) ? 1 : ibcibf[ibface];

    if (CHK_PART_UG3_GBC(ibc) == 0)
    {
      inode1 = inibf[ibface][0];
      inode2 = inibf[ibface][1];
      inode3 = inibf[ibface][2];

      x11 = x[inode1][0];
      x12 = x[inode1][1];
      x13 = x[inode1][2];
      x21 = x[inode2][0];
      x22 = x[inode2][1];
      x23 = x[inode2][2];
      x31 = x[inode3][0];
      x32 = x[inode3][1];
      x33 = x[inode3][2];

      cdfi = (CHK_BL_UG3_GBC (ibc)) ? cdf2 : cdf;

      dx1 = x21 - x11;
      dx2 = x22 - x12;
      dx3 = x23 - x13;

      df1 = cdfi * sqrt (dx1 * dx1 + dx2 * dx2 + dx3 * dx3);

      dx1 = x31 - x21;
      dx2 = x32 - x22;
      dx3 = x33 - x23;

      df2 = cdfi * sqrt (dx1 * dx1 + dx2 * dx2 + dx3 * dx3);

      dx1 = x11 - x31;
      dx2 = x12 - x32;
      dx3 = x13 - x33;

      df3 = cdfi * sqrt (dx1 * dx1 + dx2 * dx2 + dx3 * dx3);

      if (cdff > 0.0)
      {
        df1m = df1;
        df2m = df2;
        df3m = df3;

        dfmin = MIN (df1, df3);

        dfmxm = cdff * dfmin;

        dfmax = MAX (df1, df3);
        dfmax = MIN (dfmax, dfmxm);

        df1m = MIN (df1m, dfmax);
        df3m = MIN (df3m, dfmax);

        dfmin = MIN (df1, df2);

        dfmxm = cdff * dfmin;

        dfmax = MAX (df1, df2);
        dfmax = MIN (dfmax, dfmxm);

        df1m = MIN (df1m, dfmax);
        df2m = MIN (df2m, dfmax);

        dfmin = MIN (df3, df2);

        dfmxm = cdff * dfmin;

        dfmax = MAX (df3, df2);
        dfmax = MIN (dfmax, dfmxm);

        df2m = MIN (df2m, dfmax);
        df3m = MIN (df3m, dfmax);

        df1 = df1m;
        df2 = df2m;
        df3 = df3m;
      }

      df[inode1] = df[inode1] + df1 + df3;
      df[inode2] = df[inode2] + df2 + df1;
      df[inode3] = df[inode3] + df3 + df2;

      nnp[inode1] = nnp[inode1] + 2;
      nnp[inode2] = nnp[inode2] + 2;
      nnp[inode3] = nnp[inode3] + 2;
    }
  }

  for (iquad = 1; iquad <= nquad; ++iquad)
  {
    ibface = iquad + nbface;

    ibc = (ibcibf == NULL) ? 1 : ibcibf[ibface];

    if (CHK_PART_UG3_GBC(ibc) == 0)
    {
      inode1 = iniq[iquad][0];
      inode2 = iniq[iquad][1];
      inode3 = iniq[iquad][2];
      inode4 = iniq[iquad][3];

      x11 = x[inode1][0];
      x12 = x[inode1][1];
      x13 = x[inode1][2];
      x21 = x[inode2][0];
      x22 = x[inode2][1];
      x23 = x[inode2][2];
      x31 = x[inode3][0];
      x32 = x[inode3][1];
      x33 = x[inode3][2];
      x41 = x[inode4][0];
      x42 = x[inode4][1];
      x43 = x[inode4][2];

      cdfi = (CHK_BL_UG3_GBC (ibc)) ? cdf2 : cdf;

      dx1 = x21 - x11;
      dx2 = x22 - x12;
      dx3 = x23 - x13;

      df1 = cdfi * sqrt (dx1 * dx1 + dx2 * dx2 + dx3 * dx3);

      dx1 = x31 - x21;
      dx2 = x32 - x22;
      dx3 = x33 - x23;

      df2 = cdfi * sqrt (dx1 * dx1 + dx2 * dx2 + dx3 * dx3);

      dx1 = x41 - x31;
      dx2 = x42 - x32;
      dx3 = x43 - x33;

      df3 = cdfi * sqrt (dx1 * dx1 + dx2 * dx2 + dx3 * dx3);

      dx1 = x11 - x41;
      dx2 = x12 - x42;
      dx3 = x13 - x43;

      df4 = cdfi * sqrt (dx1 * dx1 + dx2 * dx2 + dx3 * dx3);

      if (cdff > 0.0)
      {
        df1m = df1;
        df2m = df2;
        df3m = df3;
        df4m = df4;

        dfmin = MIN (df1, df4);

        dfmxm = cdff * dfmin;

        dfmax = MAX (df1, df4);
        dfmax = MIN (dfmax, dfmxm);

        df1m = MIN (df1m, dfmax);
        df4m = MIN (df4m, dfmax);

        dfmin = MIN (df1, df2);

        dfmxm = cdff * dfmin;

        dfmax = MAX (df1, df2);
        dfmax = MIN (dfmax, dfmxm);

        df1m = MIN (df1m, dfmax);
        df2m = MIN (df2m, dfmax);

        dfmin = MIN (df3, df2);

        dfmxm = cdff * dfmin;

        dfmax = MAX (df3, df2);
        dfmax = MIN (dfmax, dfmxm);

        df3m = MIN (df3m, dfmax);
        df2m = MIN (df2m, dfmax);

        dfmin = MIN (df4, df3);

        dfmxm = cdff * dfmin;

        dfmax = MAX (df4, df3);
        dfmax = MIN (dfmax, dfmxm);

        df4m = MIN (df4m, dfmax);
        df3m = MIN (df3m, dfmax);

        df1 = df1m;
        df2 = df2m;
        df3 = df3m;
        df4 = df4m;
      }

      df[inode1] = df[inode1] + df1 + df4;
      df[inode2] = df[inode2] + df2 + df1;
      df[inode3] = df[inode3] + df3 + df2;
      df[inode4] = df[inode4] + df4 + df3;

      nnp[inode1] = nnp[inode1] + 2;
      nnp[inode2] = nnp[inode2] + 2;
      nnp[inode3] = nnp[inode3] + 2;
      nnp[inode4] = nnp[inode4] + 2;
    }
  }

  for (inode = 1; inode <= nnode; ++inode)
  {
    df[inode] = df[inode] / ((double) nnp[inode]);
  }

  return;

}
