#include "UG3_LIB.h"

INT_ ug3_conv_p2_bmesh_p1 (INT_ nbface,
                           INT_ nquad,
                           INT_ *p1_nbface,
                           INT_ *p1_nquad,
                           INT_1D * ibcibf,
                           INT_1D * idibf,
                           INT_1D * iqibf,
                           INT_3D * inibf,
                           INT_4D * iniq,
                           INT_3D * p2_inibf,
                           INT_5D * p2_iniq,
                           INT_1D ** p1_ibcibf,
                           INT_1D ** p1_idibf,
                           INT_1D ** p1_iqibf,
                           INT_3D ** p1_inibf,
                           INT_4D ** p1_iniq)
{

/*
 * Convert a p2 mesh defined by a p1+p2_complement mesh to a p1 boundary surface
 * sub-mesh.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_conv_p2_bmesh_p1.c,v 1.5 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ibc, ibface, id,
       inode1, inode2, inode3, inode4, inode5, inode6, inode7, inode8, inode9,
       iquad, p1_ibface, p1_iquad;
  INT_ ierr = 0;

  // set size of p1 sub-mesh

  *p1_nbface = 4*nbface;
  *p1_nquad = 4*nquad;

  // allocate p1 sub-mesh

  *p1_ibcibf = NULL;
  *p1_idibf = NULL;
  *p1_iqibf = NULL;
  *p1_inibf = NULL;
  *p1_iniq = NULL;

  if (ibcibf)
    *p1_ibcibf = (INT_1D *) ug_malloc (&ierr, ((*p1_nbface)+(*p1_nquad)+1) * sizeof (INT_1D));
  *p1_idibf = (INT_1D *) ug_malloc (&ierr, ((*p1_nbface)+(*p1_nquad)+1) * sizeof (INT_1D));
  if (iqibf)
    *p1_iqibf = (INT_1D *) ug_malloc (&ierr, ((*p1_nbface)+(*p1_nquad)+1) * sizeof (INT_1D));
  *p1_inibf = (INT_3D *) ug_malloc (&ierr, (*p1_nbface+1) * sizeof (INT_3D));
  *p1_iniq = (INT_4D *) ug_malloc (&ierr, (*p1_nquad+1) * sizeof (INT_4D));

  if (ierr)
  {
    ug_error_message ("*** ERROR 100347 : unable to allocate required memory ***");
    return (100347);
  }

  // initialize p1 sub-mesh quad flag

  if (iqibf)
    ug_set_int (1, (*p1_nbface)+(*p1_nquad), 0, *p1_iqibf);

  // create p1 sub-mesh tria-face connectivity

  p1_ibface = 0;

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    if (ibcibf) ibc = ibcibf[ibface];
    id = idibf[ibface];
    if (iqibf) iquad = iqibf[ibface];

    inode1 = inibf[ibface][0];
    inode2 = inibf[ibface][1];
    inode3 = inibf[ibface][2];

    inode4 = p2_inibf[ibface][0];
    inode5 = p2_inibf[ibface][1];
    inode6 = p2_inibf[ibface][2];

    ++p1_ibface;

    if (ibcibf) (*p1_ibcibf)[p1_ibface] = ibc;
    (*p1_idibf)[p1_ibface] = id;
    if (iqibf) (*p1_iqibf)[p1_ibface] = iquad;

    (*p1_inibf)[p1_ibface][0] = inode1;
    (*p1_inibf)[p1_ibface][1] = inode6;
    (*p1_inibf)[p1_ibface][2] = inode5;

    ++p1_ibface;

    if (ibcibf) (*p1_ibcibf)[p1_ibface] = ibc;
    (*p1_idibf)[p1_ibface] = id;
    if (iqibf) (*p1_iqibf)[p1_ibface] = iquad;

    (*p1_inibf)[p1_ibface][0] = inode2;
    (*p1_inibf)[p1_ibface][1] = inode4;
    (*p1_inibf)[p1_ibface][2] = inode6;

    ++p1_ibface;

    if (ibcibf) (*p1_ibcibf)[p1_ibface] = ibc;
    (*p1_idibf)[p1_ibface] = id;
    if (iqibf) (*p1_iqibf)[p1_ibface] = iquad;

    (*p1_inibf)[p1_ibface][0] = inode3;
    (*p1_inibf)[p1_ibface][1] = inode5;
    (*p1_inibf)[p1_ibface][2] = inode4;

    ++p1_ibface;

    if (ibcibf) (*p1_ibcibf)[p1_ibface] = ibc;
    (*p1_idibf)[p1_ibface] = id;
    if (iqibf) (*p1_iqibf)[p1_ibface] = iquad;

    (*p1_inibf)[p1_ibface][0] = inode4;
    (*p1_inibf)[p1_ibface][1] = inode5;
    (*p1_inibf)[p1_ibface][2] = inode6;
  }

  // create p1 sub-mesh quad-face connectivity

  p1_iquad = 0;

  for (iquad = 1; iquad <= nquad; ++iquad)
  {
    if (ibcibf) ibc = ibcibf[ibface];
    id = idibf[ibface];

    inode1 = iniq[iquad][0];
    inode2 = iniq[iquad][1];
    inode3 = iniq[iquad][2];
    inode4 = iniq[iquad][3];

    inode5 = p2_iniq[iquad][0];
    inode6 = p2_iniq[iquad][1];
    inode7 = p2_iniq[iquad][2];
    inode8 = p2_iniq[iquad][3];
    inode9 = p2_iniq[iquad][4];

    ++p1_iquad;

    if (ibcibf) (*p1_ibcibf)[(*p1_nbface)+p1_iquad] = ibc;
    (*p1_idibf)[(*p1_nbface)+p1_iquad] = id;

    (*p1_iniq)[p1_iquad][0] = inode1;
    (*p1_iniq)[p1_iquad][1] = inode8;
    (*p1_iniq)[p1_iquad][2] = inode9;
    (*p1_iniq)[p1_iquad][3] = inode7;

    ++p1_iquad;

    if (ibcibf) (*p1_ibcibf)[(*p1_nbface)+p1_iquad] = ibc;
    (*p1_idibf)[(*p1_nbface)+p1_iquad] = id;

    (*p1_iniq)[p1_iquad][0] = inode2;
    (*p1_iniq)[p1_iquad][1] = inode5;
    (*p1_iniq)[p1_iquad][2] = inode9;
    (*p1_iniq)[p1_iquad][3] = inode8;

    ++p1_iquad;

    if (ibcibf) (*p1_ibcibf)[(*p1_nbface)+p1_iquad] = ibc;
    (*p1_idibf)[(*p1_nbface)+p1_iquad] = id;

    (*p1_iniq)[p1_iquad][0] = inode3;
    (*p1_iniq)[p1_iquad][1] = inode6;
    (*p1_iniq)[p1_iquad][2] = inode9;
    (*p1_iniq)[p1_iquad][3] = inode5;

    ++p1_iquad;

    if (ibcibf) (*p1_ibcibf)[(*p1_nbface)+p1_iquad] = ibc;
    (*p1_idibf)[(*p1_nbface)+p1_iquad] = id;

    (*p1_iniq)[p1_iquad][0] = inode4;
    (*p1_iniq)[p1_iquad][1] = inode7;
    (*p1_iniq)[p1_iquad][2] = inode9;
    (*p1_iniq)[p1_iquad][3] = inode6;
  }

  return (0);
}
