#include "UG3_LIB.h"

INT_ ug3_conv_p1_bmesh_p2 (INT_ *nbface,
                           INT_ *nquad,
                           INT_ *nnode,
                           INT_ p1_conv_flag,
                           INT_1D ** ibcibf,
                           INT_1D ** idibf,
                           INT_1D ** iqibf,
                           INT_3D ** inibf,
                           INT_4D ** iniq,
                           DOUBLE_1D ** ds,
                           DOUBLE_1D ** del,
                           DOUBLE_3D ** x,
                           INT_3D ** p2_inibf,
                           INT_5D ** p2_iniq)
{

/*
 * Convert a standard P1 boundary mesh into a P2 mesh defined by a
 * P1+P2_complement mesh.
 * If p1_conv_flag = 1 then use linear subdivision of edges.
 * If p1_conv_flag = 2 then assume that the P1 mesh lies on a sphere.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_conv_p1_bmesh_p2.c,v 1.6 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_1D *ierribf = NULL;
  INT_1D *irfibf = NULL;
  INT_3D *ibfibf = NULL;

  INT_ ibface, ibfn, ibfn1, ibfn2, inode, inode1, inode2, jbface, jbfn,
       nbedge, nedge, nnodeb, nnoded;
  INT_ ierr = 0;
  INT_ merr = 0;
  INT_ mmsg = 1;
  INT_ mmultc = 0;
  INT_ mreorder = 1;

  double ang, b1, b2, b3, dc0, dc1, dc1d2, du1, du2, du101, du102, du201,
         dx101, dx102, dx103, dx201, dx202, dx203, 
         r, tu11, tu12, tu13, tu21, tu22, tu23, w, x01, x02, x03;

  dc0 = 0.0;
  dc1 = 1.0;
  dc1d2 = 0.5;

  // check for volume mesh

  ug3_nnodeb (*nbface, *nquad, &nnodeb, *inibf, *iniq);

  if (*nnode != nnodeb) 
  {
    ug_error_message ("*** ERROR 369 : volume mesh not allowed for p2 complement mesh creation ***");
    return (369);
  }

  // initialize p2 compliment mesh data

  *p2_inibf = NULL;
  *p2_iniq = NULL;

  // convert quads to trias

  ierr = ug3_qtria (0, 0, nbface, nquad,
                    ibcibf, idibf, &ierribf, inibf, *iniq, iqibf, &irfibf,
                    *x);

  if (ierr)
    return (ierr);

  ug_free (*iniq);

  *nquad = 0;

  *iniq = NULL;

  // get face neighbor connectivity

  ierr = ug3_ibfibf2 (merr, mmsg, mmultc, mreorder, *nbface,
                      *ibcibf, *inibf, NULL, NULL, &ibfibf, NULL, *x);

  if (ierr)
  {
    ug_free (ibfibf);
    return (ierr);
  }

  // count number of boundary edges

  nbedge = 0;

  for (ibface = 1; ibface <= *nbface; ++ibface)
  {
    for (ibfn = 0; ibfn < 3; ++ibfn)
    {
      if (ibfibf[ibface][ibfn] == 0) ++nbedge;
    }
  }

  // set number of edges

  nedge = 3*(*nbface) + (nbedge+1)/2;

  // set number of verticies in p2 compliment mesh

  nnoded = nedge;

  // allocate p2 compliment mesh connectivity and verticies

  *p2_inibf = (INT_3D *) ug_malloc (&ierr, ((*nbface)+1) * sizeof (INT_3D));
  *p2_iniq = NULL;

  *ds = (DOUBLE_1D *) ug_realloc (&ierr, *ds, (nnoded+1) * sizeof (DOUBLE_1D));
  *del = (DOUBLE_1D *) ug_realloc (&ierr, *del, (nnoded+1) * sizeof (DOUBLE_1D));
  *x = (DOUBLE_3D *) ug_realloc (&ierr, *x, (nnoded+1) * sizeof (DOUBLE_3D));

  // return on error

  if (ierr)
  {
    ug_free (ibfibf);
    ug_error_message ("*** ERROR 100348 : unable to allocate required memory ***");
    return (100348);
  }

  // initialize connectivity

  for (ibface = 1; ibface <= *nbface; ++ibface)
  {
    for (ibfn = 0; ibfn < 3; ++ibfn)
    {
      (*p2_inibf)[ibface][ibfn] = 0;
    }
  }

  // set number of p2 complement verticies

  inode = *nnode;

  for (ibface = 1; ibface <= *nbface; ++ibface)
  {
    for (ibfn = 0; ibfn < 3; ++ibfn)
    {
      if ((*p2_inibf)[ibface][ibfn] == 0)
      {
        ++inode;

        (*p2_inibf)[ibface][ibfn] = inode;

        jbface = ibfibf[ibface][ibfn];

        if (jbface)
        {
          jbfn = (ibfibf[jbface][0] == ibface) ? 0:
                 (ibfibf[jbface][1] == ibface) ? 1: 2;

          (*p2_inibf)[jbface][jbfn] = inode;
        }

        ibfn1 = (ibfn < 2) ? ibfn+1: 0;
        ibfn2 = (ibfn > 0) ? ibfn-1: 2;

        inode1 = (*inibf)[ibface][ibfn1];
        inode2 = (*inibf)[ibface][ibfn2];

        if (p1_conv_flag == 1)
        {
          (*x)[inode][0] = dc1d2 * ((*x)[inode1][0] + (*x)[inode2][0]);
          (*x)[inode][1] = dc1d2 * ((*x)[inode1][1] + (*x)[inode2][1]);
          (*x)[inode][2] = dc1d2 * ((*x)[inode1][2] + (*x)[inode2][2]);
        }
        else //if (p1_conv_flag == 2)
        {
          x01 = dc0;
          x02 = dc0;
          x03 = dc0;

          dx101 = (*x)[inode1][0] - x01;
          dx102 = (*x)[inode1][1] - x02;
          dx103 = (*x)[inode1][2] - x03;
          dx201 = (*x)[inode2][0] - x01;
          dx202 = (*x)[inode2][1] - x02;
          dx203 = (*x)[inode2][2] - x03;

          b1 = dx102 * dx203 - dx103 * dx202;
          b2 = dx103 * dx201 - dx101 * dx203;
          b3 = dx101 * dx202 - dx102 * dx201;

          tu11 = dx101;
          tu12 = dx102;
          tu13 = dx103;

          w = dc1 / sqrt (tu11 * tu11 + tu12 * tu12 + tu13 * tu13);

          tu11 = w * tu11;
          tu12 = w * tu12;
          tu13 = w * tu13;

          tu21 = b2 * tu13 - b3 * tu12;
          tu22 = b3 * tu11 - b1 * tu13;
          tu23 = b1 * tu12 - b2 * tu11;

          w = dc1 / sqrt (tu21 * tu21 + tu22 * tu22 + tu23 * tu23);

          tu21 = w * tu21;
          tu22 = w * tu22;
          tu23 = w * tu23;

          du101 = tu11 * dx101 + tu12 * dx102 + tu13 * dx103;
          du102 = tu21 * dx101 + tu22 * dx102 + tu23 * dx103;
          du201 = tu11 * dx201 + tu12 * dx202 + tu13 * dx203;

          r = sqrt (du101 * du101 + du102 * du102);

          ang = dc1d2 * (acos (du101 / r) + acos (du201 / r));

          du1 = r * cos (ang);
          du2 = r * sin (ang);

          (*x)[inode][0] = tu11 * du1 + tu21 * du2 + x01;
          (*x)[inode][1] = tu12 * du1 + tu22 * du2 + x02;
          (*x)[inode][2] = tu13 * du1 + tu23 * du2 + x03;
        }
      }
    }
  }

  // set new number of nodes

  *nnode = inode;

  // set p2 compliment mesh Initial BL Normal Spacing

  if (*ds)
    ug_set_double (nnodeb+1, *nnode, dc0, *ds);

  // set p2 compliment mesh BL Thickness

  if (*del)
    ug_set_double (nnodeb+1, *nnode, dc0, *del);

  ug_free (ibfibf);

  return (ierr);
}
