#include "UG3_LIB.h"

INT_ ug3_chkq
 (INT_ ielem00,
  INT_ merr,
  INT_ mmsg,
  INT_ nelem,
  INT_4D * iniel,
  INT_1D * ierriel,
  double angq,
  DOUBLE_3D * x)

{

/*
 * Check dihedral angles for each tetrahedral element of volume grid.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_chkq.c,v 1.23 2022/11/21 00:25:14 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_133 Text;

  INT_ ielem, ierr, inode1, inode2, inode3, inode4;

  double cosq, cosqs, dc0, dc1, dc45, w, w21, w31, w32, w41, w42, w43,
         x11, x12, x13, x21, x22, x23, x31, x32, x33, x41, x42, x43;

  dc0 = 0.0;
  dc1 = 1.0;
  dc45 = 45.0;

  if (angq == dc0)
    return (0);

  if (mmsg == 2)
  {
    snprintf (Text, sizeof(Text), "Checking Quality   : Elements          =%10i", (int) nelem);
    ug_message (Text);
  }

  cosq = cos (angq * atan (dc1) / dc45);
  cosqs = fabs (cosq) * cosq;

  ierr = 0;

  ielem = ielem00;

  do
  {
    inode1 = iniel[ielem][0];
    inode2 = iniel[ielem][1];
    inode3 = iniel[ielem][2];
    inode4 = iniel[ielem][3];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x13 = x[inode1][2];
    x21 = x[inode2][0];
    x22 = x[inode2][1];
    x23 = x[inode2][2];
    x31 = x[inode3][0];
    x32 = x[inode3][1];
    x33 = x[inode3][2];
    x41 = x[inode4][0];
    x42 = x[inode4][1];
    x43 = x[inode4][2];

    ug3_dh_ang_w (x11, x12, x13, 
                  x21, x22, x23, 
                  x31, x32, x33, 
                  x41, x42, x43,
                  &w21, &w31, &w32, &w41, &w42, &w43);

    w = MAX (w21, w31);
    w = MAX (w41, w);
    w = MAX (w32, w);
    w = MAX (w42, w);
    w = MAX (w43, w);

    w = w + cosqs;

    if (w > dc0)
    {
      ierr = 1;

      if (merr)
        ierriel[ielem] = -1;
    }

    ++ielem;
  }
  while (ielem <= nelem && (! ierr || merr));

  if (ierr)
  {
    if (merr)
    {
      ug_error_message ("*** ERROR 317 : element found with dihedral angle above maximum allowable ***");
      return (317);
    }
    else
      return (-1);
  }

  if (mmsg == 2)
    ug_message ("Checking Quality   : Quality OK");

  return (0);

}
