#include "UG3_LIB.h"

INT_ ug3_chkbsurf2 (INT_ mmsg,
                    INT_ mchk,
                    INT_ mclosed,
                    INT_ mmultc,
                    INT_ mreorder,
                    INT_ nbface,
                    INT_ *nbo,
                    INT_ nnode,
                    INT_1D * ibcibf,
                    INT_3D ** ibfibf,
                    INT_1D ** iboibf,
                    INT_3D * inibf,
                    DOUBLE_3D * x)
{

/*
 * Check boundary surface grid.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_chkbsurf2.c,v 1.12 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_1D *ibfichk = NULL;
  INT_1D *ibfin = NULL;
  INT_1D *ierribf = NULL;
  INT_1D *libfin = NULL;
  INT_1D *mchkbf = NULL;
  INT_1D *mchkbn = NULL;

  INT_ found, ibface, ibfn, jbface;
  INT_ ierr = 0;
  INT_ merr = 0;
  INT_ mopen = 0;
  INT_ msetbc = 1;
  INT_ nbfpnt = 0;
  INT_ nbfpntd = 0;

  *ibfibf = (INT_3D *) ug_malloc (&ierr, (nbface+1) * sizeof (INT_3D));
  ibfichk = (INT_1D *) ug_malloc (&ierr, (nbface+1) * sizeof (INT_1D));
  *iboibf = (INT_1D *) ug_malloc (&ierr, (nbface+1) * sizeof (INT_1D));
  libfin = (INT_1D *) ug_malloc (&ierr, (nnode+2) * sizeof (INT_1D));
  mchkbf = (INT_1D *) ug_malloc (&ierr, (nbface+1) * sizeof (INT_1D));
  mchkbn = libfin;

  if (ierr)
  {
    ug_error_message ("*** ERROR 102017 : unable to allocate required memory ***");
    ierr = 102017;
  }

  if (ierr == 0 && mchk && ibcibf)
    ierr = ug3_chkbc0 (merr, nbface, ibcibf, ierribf);

  if (ierr == 0 && mchk)
    ierr = ug3_chkbn (merr, mmsg, nbface, nnode, inibf, mchkbn, ierribf);

  if (ierr == 0)
    ierr = ug3_ibfin (nbface, &nbfpntd, nnode, &nbfpnt, inibf, &ibfin, libfin);

  if (ierr == 0)
    ug3_ibfibf0 (msetbc, nbface,
                 ibcibf, ibfin, inibf, libfin, ibfichk, mchkbf, *ibfibf);

  if (ierr == 0)
    ierr = ug3_ibfibf (merr, mmsg, mmultc, mreorder, nbface,
                       ibcibf, ibfin, inibf, NULL, NULL,
                       libfin, ibfichk, mchkbf, *ibfibf, ierribf,
                       x);

  if (ierr == 0 && mchk)
    ierr = ug3_chkb (mclosed, merr, mmsg,
                     nbface, ibcibf, *ibfibf, inibf, ierribf);

  if (ierr == 0)
    ug3_iboibf (mmsg, nbface, nbo, *ibfibf, mchkbf, *iboibf);

  if (ierr == 0)
    ierr = ug3_ibor (mclosed, merr, mmsg, mopen, nbface, *nbo,
                     ibcibf, *ibfibf, *iboibf, ierribf, inibf, NULL,
                     x);

  if (ierr == 0 && ibcibf)
  {
    found = 0;

    ibface = 1;

    do
    {
      if (CHK_BL_INT_UG3_GBC (ibcibf[ibface])) found = 1;

      ++ibface;
    }
    while (ibface <= nbface && found == 0);

    if (found)
    {
      found = 0;

      for (ibface = 1; ibface <= nbface; ++ibface)
      {
        if (CHK_BL_INT_UG3_GBC (ibcibf[ibface]))
        {
          for (ibfn = 0; ibfn < 3; ++ibfn)
          {
            jbface = (*ibfibf)[ibface][ibfn];

            if (jbface)
            {
              if (CHK_BL_INT_UG3_GBC (ibcibf[jbface]) == 0 &&
                  ibcibf[jbface] != FARFIELD_UG3_GBC)
              {
                found = 1;

                (*ibfibf)[ibface][ibfn] = -jbface;

                if (ibface == (*ibfibf)[jbface][0])
                  (*ibfibf)[jbface][0] = -ibface;
                else if (ibface == (*ibfibf)[jbface][1])
                  (*ibfibf)[jbface][1] = -ibface;
                else if (ibface == (*ibfibf)[jbface][2])
                  (*ibfibf)[jbface][2] = -ibface;
              }
            }
          }
        }
      }
    }

    if (found)
    {
      *nbo = 0;

      ug_set_int (1, nbface, 0, *iboibf);

      ug3_iboibf (mmsg, nbface, nbo, *ibfibf, mchkbf, *iboibf);

      for (ibface = 1; ibface <= nbface; ++ibface)
      {
        for (ibfn = 0; ibfn < 3; ++ibfn)
        {
          (*ibfibf)[ibface][ibfn] = ug_abs ((*ibfibf)[ibface][ibfn]);
        }
      }
    }
  }

  ug_free (ibfichk);
  ug_free (ibfin);
  ug_free (libfin);
  ug_free (mchkbf);

  if (ierr)
    return ierr;

  return 0;
}
