#include "UG3_LIB.h"

INT_ ug3_chkbsurf0
 (INT_ mmsg,
  INT_ mclosed,
  INT_ merr,
  INT_ mmultc,
  INT_ mopen,
  INT_ mreorder,
  INT_ nbface,
  INT_ nnode,
  INT_1D * ibcibf,
  INT_1D ** ierribf,
  INT_3D * inibf,
  INT_1D * irfibf,
  double angblisimx,
  double angqbf,
  double angqbfmin,
  double angrbfsd,
  DOUBLE_3D * x)

{

/*
 * Check and reorder a boundary surface grid.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_chkbsurf0.c,v 1.13 2021/11/26 09:51:27 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_3D *ibfibf = NULL;
  INT_1D *ibfichk = NULL;
  INT_1D *ibfin = NULL;
  INT_1D *iboibf = NULL;
  INT_1D *libfin = NULL;
  INT_1D *mchkbf = NULL;
  INT_1D *mchkbn = NULL;

  INT_ ierr = 0;
  INT_ msetbc = 0;
  INT_ nbfpntd = 0;
  INT_ nbfpnt = 0;
  INT_ nbo = 0;

  ibfibf = (INT_3D *) ug_malloc (&ierr, (nbface+1) * sizeof (INT_3D));
  ibfichk = (INT_1D *) ug_malloc (&ierr, (nbface+1) * sizeof (INT_1D));
  iboibf = (INT_1D *) ug_malloc (&ierr, (nbface+1) * sizeof (INT_1D));
  if (merr) *ierribf = (INT_1D *) ug_malloc (&ierr, (nbface+1) * sizeof (INT_1D));
  libfin = (INT_1D *) ug_malloc (&ierr, (nnode+2) * sizeof (INT_1D));
  mchkbf = (INT_1D *) ug_malloc (&ierr, (nbface+1) * sizeof (INT_1D));
  mchkbn = (INT_1D *) ug_malloc (&ierr, (nnode+1) * sizeof (INT_1D));

  if (merr)
    ug_set_int (1, nbface, 0, *ierribf);

  if (ierr == 0)
    ierr = ug3_chkbn (merr, mmsg, nbface, nnode, inibf, mchkbn, *ierribf);

  if (ierr == 0)
    ierr = ug3_chkbq (merr, mmsg, nbface, inibf, *ierribf, angqbf, angqbfmin, x);

  if (ierr == 0)
    ierr = ug3_ibfin (nbface, &nbfpntd, nnode, &nbfpnt, inibf, &ibfin, libfin);

  if (ierr == 0)
    ierr = ug3_ibfibf (merr, mmsg, mmultc, mreorder, nbface,
                       ibcibf, ibfin, inibf, irfibf, NULL,
                       libfin, ibfichk, mchkbf, ibfibf, *ierribf,
                       x);

  if (ierr == 0)
    ug3_iboibf (mmsg, nbface, &nbo, ibfibf, mchkbf, iboibf);

  if (ierr == 0 && mreorder)
    ierr = ug3_ibor (mclosed, merr, mmsg, mopen, nbface, nbo,
                     ibcibf, ibfibf, iboibf, *ierribf, inibf, irfibf,
                     x);

  if (ierr == 0)
    ierr = ug3_chkblis (merr, msetbc, nbface,
                        ibcibf, ibfibf, ibfin, *ierribf, inibf, libfin,
                        angblisimx, x);

  if (ierr == 0)
    ierr = ug3_chkb (mclosed, merr, mmsg,
                     nbface, ibcibf, ibfibf, inibf, *ierribf);

  if (ierr == 0)
    ierr = ug3_chkbc (merr, nbface, nbo, ibcibf, ibfibf, iboibf, *ierribf);

  if (ierr == 0)
    ierr = ug3_chkbda (merr, mmsg, nbface, ibfibf, inibf, mchkbf, *ierribf,
                       angrbfsd, x);

  ug_free (ibfibf);
  ug_free (ibfichk);
  ug_free (iboibf);
  if (ierr == 0 && merr)
  {
    ug_free (*ierribf);
    *ierribf = NULL;
  }
  ug_free (ibfin);
  ug_free (libfin);
  ug_free (mchkbf);
  ug_free (mchkbn);

  return (ierr);

}
