#include "UG3_LIB.h"

INT_ ug3_chkbq
 (INT_ merr,
  INT_ mmsg,
  INT_ nbface,
  INT_3D * inibf,
  INT_1D * ierribf,
  double angqbf,
  double angqbfmin,
  DOUBLE_3D * x)

{

/*
 * Check planar face angles for each triangular face of surface grid.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_chkbq.c,v 1.22 2022/11/21 00:25:14 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 * 
 */

  CHAR_133 Text;

  INT_ ibface, ierr, inode1, inode2, inode3, jerr;

  double cosqbf, cosqbfs, cosqbfmin, cosqbfmins, dc0, dc1, dc45, dc180,
         w, w1, w2, w3, wmax;

  dc0 = 0.0;
  dc1 = 1.0;
  dc45 = 45.0;
  dc180 = 180.0;

  if (angqbf == dc180 && angqbfmin == dc0)
    return (0);

  if (mmsg == 2)
  {
    snprintf (Text, sizeof(Text), "Checking B-Quality : B-Faces           =%10i", (int) nbface);
    ug_message (Text);
  }

  cosqbf = cos (angqbf * atan (dc1) / dc45);
  cosqbfs = cosqbf * fabs (cosqbf);

  cosqbfmin = (angqbfmin > dc0) ? cos (angqbfmin * atan (dc1) / dc45): dc1;
  cosqbfmins = cosqbfmin * fabs (cosqbfmin);

  if (merr)
  {
    for (ibface = 1; ibface <= nbface; ++ibface)
    {
      ierribf[ibface] = 0;
    }
  }

  ierr = 0;
  jerr = 0;

  ibface = 1;

  do
  {
    inode1 = inibf[ibface][0];
    inode2 = inibf[ibface][1];
    inode3 = inibf[ibface][2];

    ug3_face_ang_w (inode1, inode2, inode3, &w1, &w2, &w3, &w, x);

    wmax = MAX (w1, w2);
    wmax = MAX (wmax, w3);

    if (w < cosqbfs)
    {
      ierr = 1;

      if (merr)
        ierribf[ibface] = -1;
    }
    else if (wmax > cosqbfmins)
    {
      jerr = 1;

      if (merr)
        ierribf[ibface] = -1;
    }

    ++ibface;
  }
  while (ibface <= nbface && (! ierr || merr));

  if (ierr || jerr)
  {
    if (merr)
    {
      if (ierr)
      {
        ug_error_message ("*** ERROR 200302 : face angle is too large for at least one boundary face ***");
        ug_error_message ("*** to disable this check use option angqbf=180 ***");
      }
      if (jerr)
      {
        ug_error_message ("*** ERROR 200302 : face angle is too small for at least one boundary face ***");
        ug_error_message ("*** this could be intentional with high-aspect-ratio boundary faces ***");
        ug_error_message ("*** to disable this check use option angqbfmin=0 ***");
      }
      return (200302);
    }
    else
      return (-1);
  }

  if (mmsg == 2)
    ug_message ("Checking B-Quality : B-Quality OK");

  return (0);
}
