#include "UG3_LIB.h"

INT_ ug3_chkbc0
 (INT_ merr,
  INT_ nbface,
  INT_1D * ibcibf,
  INT_1D * ierribf)

{

/*
 * Check grid boundary condition flag values.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_chkbc0.c,v 1.4 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ibface, ierr;

  if (ibcibf == NULL)
    return (0);

  // initialize error flag

  ierr = 0;

  if (merr)
  {
    for (ibface = 1; ibface <= nbface; ++ibface)
    {
      ierribf[ibface] = 0;
    }
  }

  // check for invalid grid BC flag

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    if (! CHK_VALID_UG3_GBC (ibcibf[ibface]))
    {
      ierr = 1;

      if (merr)
        ierribf[ibface] = -1;
      else
      {
        ug_error_message ("*** ERROR 343 : surface grid BC flags are not all set to valid values ***");
        return (343);
      }
    }
  }

  // exit if an error was found

  if (ierr)
  {
    ug_error_message ("*** ERROR 200307 : surface grid BC flags are not all set to valid values ***");
    return (200307);
  }

  return (0);

}
