#include "UG3_LIB.h"

INT_ ug3_chkbc
 (INT_ merr,
  INT_ nbface,
  INT_ nbo,
  INT_1D * ibcibf,
  INT_3D * ibfibf,
  INT_1D * iboibf,
  INT_1D * ierribf)

{

/*
 * Check grid boundary condition flag values.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_chkbc.c,v 1.17 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ibc, ibface, ibfn, ibo, ierr, jbc, jbface, jbo;

  if (ibcibf == NULL)
    return (0);

  // initialize error flag

  ierr = 0;

  // check for invalid grid BC flag

  ierr = ug3_chkbc0 (merr, nbface, ibcibf, ierribf);

  if (ierr)
    return (ierr);

  // check for fixed BL intersecting surface face that has a neighbor that is
  // not a fixed BL intersecting surface, BL generating surface or standard
  // solid surface

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    ibc = ibcibf[ibface];

    if (CHK_FIXED_BL_INT_UG3_GBC (ibc))
    {
      for (ibfn = 0; ibfn <= 2; ++ibfn)
      {
        jbface = ibfibf[ibface][ibfn];

        jbc = ibcibf[jbface];

        if (! CHK_FIXED_BL_INT_UG3_GBC (jbc) &&
            ! CHK_STD_BL_UG3_GBC (jbc) &&
            ! CHK_STD_UG3_GBC (jbc))
        {
          ierr = 1;

          if (merr)
          {
            ierribf[ibface] = -1;
            ierribf[jbface] = -1;
          }
          else
          {
            ug_error_message ("*** ERROR 342 : fixed surface that intersects BL found adjacent to an invalid grid BC ***");
            return (342);
          }
        }
      }
    }
  }

  // exit if an error was found

  if (ierr == 1)
  {
    ug_error_message ("*** ERROR 200305 : fixed surface that intersects BL found adjacent to an invalid grid BC ***");
    ug_error_message ("*** neighbors of fixed surfaces may only be another fixed surface that ***");
    ug_error_message ("*** intersects the BL region, a standard solid BL generating surface, or a ***");
    ug_error_message ("*** standard solid surface ***");
    return (200305);
  }


  // check that their are no closed bodies that are entirely set to a grid BC
  // of an embedded/transparent BL generating surface

  for (ibo = 1; ibo <= nbo; ++ibo)
  {
    jbo = 0;

    ibface = 1;

    do
    {
      if (iboibf[ibface] == ibo)
        jbo = ibo;

      ++ibface;
    }
    while (ibface <= nbface && jbo == 0);

    ibface = 1;

    while (ibface <= nbface && jbo)
    {
      if (iboibf[ibface] == ibo)
      {
        ibc = ibcibf[ibface];

        if (CHK_BL_UG3_GBC (ibc) && CHK_TRANSP_UG3_GBC (ibc))
        {
          ibfn = 0;

          do
          {
            jbface = ibfibf[ibface][ibfn];

            if (jbface)
            {
              if (iboibf[jbface] == ibo)
              {
                jbc = ibcibf[jbface];

                if (! CHK_BL_UG3_GBC (jbc) || ! CHK_TRANSP_UG3_GBC (jbc))
                  jbo = 0;
              }
              else
                jbo = 0;
            }
            else
              jbo = 0;

            ++ibfn;
          }
          while (ibfn <= 2 && jbo);
        }
        else
          jbo = 0;
      }

      ++ibface;
    }

    if (jbo)
    {
      if (! merr)
      {
        ug_error_message ("*** ERROR 345 : closed embedded transparent BL generating surface found ***");
        return (345);
      }
      else
      {
        ierr = 1;

        for (ibface = 1; ibface <= nbface; ++ibface)
        {
          if (iboibf[ibface] == jbo)
            ierribf[ibface] = -1;
        }
      }
    }
  }

  // exit if an error was found

  if (ierr == 1)
  {
    ug_error_message ("*** ERROR 200316 : closed embedded transparent BL generating surface found ***");
    return (200316);
  }

  return (0);

}
