#include "UG3_LIB.h"

INT_ ug3_check_bgdata_file (char Case_Name[],
                            char File_Name[])
{

/*
 * Check if BGDATA background mesh data file exists.
 * 
 * SD3 LIB : Sub-Domain Utility Library
 * 3D Version : $Id: ug3_check_bgdata_file.c,v 1.3 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  FILE *Data_File = NULL;

  strcpy (File_Name, Case_Name);

  if (sizeof (INT_) == sizeof (int))
    strcat (File_Name, ".b8.bgdata");
  else
    strcat (File_Name, ".b8l.bgdata");

  Data_File = ug_fopen (File_Name, "r");

  if (Data_File == NULL)
  {
    strcpy (File_Name, "");
    return (-1);
  }

  ug_fclose (Data_File);

  return (0);
}
