#include "UG3_LIB.h"

INT_ ug3_bnd_nodes
 (INT_ mremove,
  INT_ *nnodeb,
  INT_ nnode,
  INT_ nbface,
  INT_ nquad,
  INT_3D * inibf,
  INT_4D * iniq,
  INT_1D ** node_map,
  DOUBLE_1D * del,
  DOUBLE_1D * ds,
  DOUBLE_3D * x)

{

/*
 * Determine node index map for boundary nodes and optionally either remove
 * interior nodes from grid data or continue node index map with interior nodes
 * following boundary nodes.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_bnd_nodes.c,v 1.17 2021/04/10 18:37:05 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ibface, ierr, inode, inode1, inode2, inode3, inode4, inodeb, inodev,
       iquad;

  ierr = 0;

  ug3_nnodeb (nbface, nquad, nnodeb, inibf, iniq);
 
  *node_map = (INT_1D *) ug_malloc (&ierr, (nnode+1) * sizeof (INT_1D));

  if (ierr > 0)
  {
    ug_error_message ("*** ERROR 100314 : unable to allocate required memory ***");
    return (100314);
  }

  for (inode = 1; inode <= nnode; ++inode)
  {
    (*node_map)[inode] = 0;
  }

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    inode1 = inibf[ibface][0];
    inode2 = inibf[ibface][1];
    inode3 = inibf[ibface][2];

    (*node_map)[inode1] = 1;
    (*node_map)[inode2] = 1;
    (*node_map)[inode3] = 1;
  }

  for (iquad = 1; iquad <= nquad; ++iquad)
  {
    inode1 = iniq[iquad][0];
    inode2 = iniq[iquad][1];
    inode3 = iniq[iquad][2];
    inode4 = iniq[iquad][3];

    (*node_map)[inode1] = 1;
    (*node_map)[inode2] = 1;
    (*node_map)[inode3] = 1;
    (*node_map)[inode4] = 1;
  }

  inodeb = 0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    if ((*node_map)[inode] == 1)
    {
      ++inodeb;

      (*node_map)[inode] = inodeb;
    }
  }

  if (mremove == -1)
  {
    *nnodeb = inodeb;

    inodev = *nnodeb;

    for (inode = 1; inode <= nnode; ++inode)
    {
      if ((*node_map)[inode] == 0)
      {
        ++inodev;

        (*node_map)[inode] = inodev;
      }
    }
  }

  else if (mremove == 0)
    *nnodeb = inodeb;

  else if (mremove == 1)
  {
    if (inodeb < *nnodeb)
    {
      for (inode = 1; inode <= nnode; ++inode)
      {
        inodeb = (*node_map)[inode];

        if (inodeb > 0)
        {
          x[inodeb][0] = x[inode][0];
          x[inodeb][1] = x[inode][1];
          x[inodeb][2] = x[inode][2];

          if (ds != NULL)
            ds[inodeb] = ds[inode];

          if (del != NULL)
            del[inodeb] = del[inode];
        }
      }

      for (ibface = 1; ibface <= nbface; ++ibface)
      {
        inode1 = inibf[ibface][0];
        inode2 = inibf[ibface][1];
        inode3 = inibf[ibface][2];

        inibf[ibface][0] = (*node_map)[inode1];
        inibf[ibface][1] = (*node_map)[inode2];
        inibf[ibface][2] = (*node_map)[inode3];
      }

      for (iquad = 1; iquad <= nquad; ++iquad)
      {
        inode1 = iniq[iquad][0];
        inode2 = iniq[iquad][1];
        inode3 = iniq[iquad][2];
        inode4 = iniq[iquad][3];

        iniq[iquad][0] = (*node_map)[inode1];
        iniq[iquad][1] = (*node_map)[inode2];
        iniq[iquad][2] = (*node_map)[inode3];
        iniq[iquad][3] = (*node_map)[inode4];
      }
    }

    *nnodeb = inodeb;

    ug_free (*node_map);

    *node_map = NULL;
  }

  return (0);

}

INT_ ug3_p2_bnd_nodes
 (INT_ mremove,
  INT_ *nnodeb,
  INT_ nnode,
  INT_ nbface,
  INT_ nquad,
  INT_ p_order,
  INT_3D * inibf,
  INT_4D * iniq,
  INT_3D * p2_inibf,
  INT_5D * p2_iniq,
  INT_1D ** node_map,
  DOUBLE_1D * del,
  DOUBLE_1D * ds,
  DOUBLE_3D * x)

{

/*
 * Determine node index map for boundary nodes and optionally either remove
 * interior nodes from grid data or continue node index map with interior nodes
 * following boundary nodes.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_bnd_nodes.c,v 1.17 2021/04/10 18:37:05 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ibface, ierr, inode, inode1, inode2, inode3, inode4, inode5, inodeb,
       inodev, iquad;

  ierr = 0;

  ug3_p2_nnodeb (nbface, nquad, nnodeb, p_order, inibf, iniq, p2_inibf, p2_iniq);
 
  *node_map = (INT_1D *) ug_malloc (&ierr, (nnode+1) * sizeof (INT_1D));

  if (ierr > 0)
  {
    ug_error_message ("*** ERROR 100355 : unable to allocate required memory ***");
    return (100355);
  }

  for (inode = 1; inode <= nnode; ++inode)
  {
    (*node_map)[inode] = 0;
  }

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    inode1 = inibf[ibface][0];
    inode2 = inibf[ibface][1];
    inode3 = inibf[ibface][2];

    (*node_map)[inode1] = 1;
    (*node_map)[inode2] = 1;
    (*node_map)[inode3] = 1;
  }

  for (iquad = 1; iquad <= nquad; ++iquad)
  {
    inode1 = iniq[iquad][0];
    inode2 = iniq[iquad][1];
    inode3 = iniq[iquad][2];
    inode4 = iniq[iquad][3];

    (*node_map)[inode1] = 1;
    (*node_map)[inode2] = 1;
    (*node_map)[inode3] = 1;
    (*node_map)[inode4] = 1;
  }

  if (p_order == 2)
  {
    for (ibface = 1; ibface <= nbface; ++ibface)
    {
      inode1 = p2_inibf[ibface][0];
      inode2 = p2_inibf[ibface][1];
      inode3 = p2_inibf[ibface][2];

      (*node_map)[inode1] = 1;
      (*node_map)[inode2] = 1;
      (*node_map)[inode3] = 1;
    }

    for (iquad = 1; iquad <= nquad; ++iquad)
    {
      inode1 = p2_iniq[iquad][0];
      inode2 = p2_iniq[iquad][1];
      inode3 = p2_iniq[iquad][2];
      inode4 = p2_iniq[iquad][3];
      inode5 = p2_iniq[iquad][4];

      (*node_map)[inode1] = 1;
      (*node_map)[inode2] = 1;
      (*node_map)[inode3] = 1;
      (*node_map)[inode4] = 1;
      (*node_map)[inode5] = 1;
    }
  }

  inodeb = 0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    if ((*node_map)[inode] == 1)
    {
      ++inodeb;

      (*node_map)[inode] = inodeb;
    }
  }

  if (mremove == -1)
  {
    *nnodeb = inodeb;

    inodev = *nnodeb;

    for (inode = 1; inode <= nnode; ++inode)
    {
      if ((*node_map)[inode] == 0)
      {
        ++inodev;

        (*node_map)[inode] = inodev;
      }
    }
  }

  else if (mremove == 0)
    *nnodeb = inodeb;

  else if (mremove == 1)
  {
    if (inodeb < *nnodeb)
    {
      for (inode = 1; inode <= nnode; ++inode)
      {
        inodeb = (*node_map)[inode];

        if (inodeb > 0)
        {
          x[inodeb][0] = x[inode][0];
          x[inodeb][1] = x[inode][1];
          x[inodeb][2] = x[inode][2];

          if (ds != NULL)
            ds[inodeb] = ds[inode];

          if (del != NULL)
            del[inodeb] = del[inode];
        }
      }

      for (ibface = 1; ibface <= nbface; ++ibface)
      {
        inode1 = inibf[ibface][0];
        inode2 = inibf[ibface][1];
        inode3 = inibf[ibface][2];

        inibf[ibface][0] = (*node_map)[inode1];
        inibf[ibface][1] = (*node_map)[inode2];
        inibf[ibface][2] = (*node_map)[inode3];
      }

      for (iquad = 1; iquad <= nquad; ++iquad)
      {
        inode1 = iniq[iquad][0];
        inode2 = iniq[iquad][1];
        inode3 = iniq[iquad][2];
        inode4 = iniq[iquad][3];

        iniq[iquad][0] = (*node_map)[inode1];
        iniq[iquad][1] = (*node_map)[inode2];
        iniq[iquad][2] = (*node_map)[inode3];
        iniq[iquad][3] = (*node_map)[inode4];
      }

      if (p_order == 2)
      {
        for (ibface = 1; ibface <= nbface; ++ibface)
        {
          inode1 = p2_inibf[ibface][0];
          inode2 = p2_inibf[ibface][1];
          inode3 = p2_inibf[ibface][2];

          p2_inibf[ibface][0] = (*node_map)[inode1];
          p2_inibf[ibface][1] = (*node_map)[inode2];
          p2_inibf[ibface][2] = (*node_map)[inode3];
        }

        for (iquad = 1; iquad <= nquad; ++iquad)
        {
          inode1 = p2_iniq[iquad][0];
          inode2 = p2_iniq[iquad][1];
          inode3 = p2_iniq[iquad][2];
          inode4 = p2_iniq[iquad][3];
          inode5 = p2_iniq[iquad][4];

          p2_iniq[iquad][0] = (*node_map)[inode1];
          p2_iniq[iquad][1] = (*node_map)[inode2];
          p2_iniq[iquad][2] = (*node_map)[inode3];
          p2_iniq[iquad][3] = (*node_map)[inode4];
          p2_iniq[iquad][4] = (*node_map)[inode5];
        }
      }
    }

    *nnodeb = inodeb;

    ug_free (*node_map);

    *node_map = NULL;
  }

  return (0);

}
