#include "UG3_LIB.h"

double ug3_angmax
 (INT_ ielem00,
  INT_ nelem,
  INT_4D * iniel,
  DOUBLE_3D * x)

{

/*
 * Find maximum dihedral angle for all tetrahedral elements of volume grid.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_angmax.c,v 1.13 2021/02/07 01:45:08 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ielem, inode1, inode2, inode3, inode4;

  double angmax, dc0, dc1, dc45, w, wmax, w21, w31, w32, w41, w42, w43,
         x11, x12, x13, x21, x22, x23, x31, x32, x33, x41, x42, x43;

  dc0 = 0.0;
  dc1 = 1.0;
  dc45 = 45.0;

  wmax = - dc1;

  for (ielem = ielem00; ielem <= nelem; ++ielem)
  {
    inode1 = iniel[ielem][0];
    inode2 = iniel[ielem][1];
    inode3 = iniel[ielem][2];
    inode4 = iniel[ielem][3];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x13 = x[inode1][2];
    x21 = x[inode2][0];
    x22 = x[inode2][1];
    x23 = x[inode2][2];
    x31 = x[inode3][0];
    x32 = x[inode3][1];
    x33 = x[inode3][2];
    x41 = x[inode4][0];
    x42 = x[inode4][1];
    x43 = x[inode4][2];

    ug3_dh_ang_w (x11, x12, x13, 
                  x21, x22, x23, 
                  x31, x32, x33, 
                  x41, x42, x43,
                  &w21, &w31, &w32, &w41, &w42, &w43);

    wmax = MAX (w21, wmax);
    wmax = MAX (w31, wmax);
    wmax = MAX (w41, wmax);
    wmax = MAX (w32, wmax);
    wmax = MAX (w42, wmax);
    wmax = MAX (w43, wmax);
  }

  w = sqrt (fabs (wmax));
  w = MIN (w, dc1);

  angmax = (wmax >= dc0) ? acos (- w): acos (w);
  angmax = angmax * dc45 / atan (dc1);

  return (angmax);

}
