#include "UG2_LIB.h"

void ug2_xmax
 (INT_ nnode,
  double *x1max,
  double *x1min,
  double *x2max,
  double *x2min,
  DOUBLE_2D * x)

{

/*
 * Determine min/max coordinates for a given set of nodes.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_xmax.c,v 1.6 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ inode;

  double x1, x2;

  inode = 1;

  x1 = x[inode][0];
  x2 = x[inode][1];

  *x1max = x1;
  *x2max = x2;
  *x1min = x1;
  *x2min = x2;

  for (inode = 2; inode <= nnode; ++inode)
  {
    x1 = x[inode][0];
    x2 = x[inode][1];

    *x1max = MAX (*x1max, x1);
    *x2max = MAX (*x2max, x2);
    *x1min = MIN (*x1min, x1);
    *x2min = MIN (*x2min, x2);
  }

  return;

}
